/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.connection.validation.ConnectionValidationSettings;
import com.mulesoft.connectivity.rest.commons.api.connection.validation.ConnectionValidator;
import com.mulesoft.connectivity.rest.commons.api.error.RequestException;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.HttpResponseInterceptorDescriptor;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.streaming.StreamingHelper;
import com.mulesoft.connectivity.rest.commons.internal.interception.HttpResponseInterceptorFactory;
import com.mulesoft.connectivity.rest.commons.internal.interception.model.DefaultHttpRequest;
import com.mulesoft.connectivity.rest.commons.internal.util.ConnectionValidationUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.FromCursorProviderInputStream;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestConnection
implements RestConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRestConnection.class);
    private static final String REMOTELY_CLOSED = "Remotely closed";
    private final String baseUri;
    private final String configName;
    private final HttpClient httpClient;
    private final HttpAuthentication authentication;
    private final MultiMap<String, String> defaultQueryParams;
    private final MultiMap<String, String> defaultHeaders;
    private final ExpressionLanguage expressionLanguage;
    private final Map<String, Object> bindings;
    private HttpResponseInterceptorFactory httpResponseInterceptorFactory = new HttpResponseInterceptorFactory();

    public DefaultRestConnection(String baseUri, String configName, HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders, ExpressionLanguage expressionLanguage) {
        this(baseUri, configName, httpClient, authentication, defaultQueryParams, defaultHeaders, expressionLanguage, Collections.emptyMap());
    }

    public DefaultRestConnection(String baseUri, String configName, HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders, ExpressionLanguage expressionLanguage, Map<String, Object> bindings) {
        Objects.requireNonNull(expressionLanguage, "'expressionLanguage' cannot be null");
        this.baseUri = baseUri;
        this.configName = configName;
        this.httpClient = httpClient;
        this.authentication = authentication;
        this.defaultQueryParams = this.nullSafe(defaultQueryParams);
        this.defaultHeaders = this.nullSafe(defaultHeaders);
        this.expressionLanguage = expressionLanguage;
        this.bindings = bindings;
    }

    private void merge(MultiMap<String, String> defaultValues, Predicate<String> appendPredicate, BiConsumer<String, List<String>> appender) {
        defaultValues.keySet().forEach(k -> {
            if (appendPredicate.test((String)k)) {
                appender.accept((String)k, defaultValues.getAll(k));
            }
        });
    }

    @Override
    public CompletableFuture<Result<String, HttpResponseAttributes>> bodylessRequest(RestRequestBuilder requestBuilder, int responseTimeoutMillis, MediaType defaultResponseMediaType, StreamingHelper streamingHelper) {
        CompletableFuture<Result<String, HttpResponseAttributes>> future = new CompletableFuture<Result<String, HttpResponseAttributes>>();
        this.request(requestBuilder, responseTimeoutMillis, defaultResponseMediaType, streamingHelper).whenComplete((r, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
            } else {
                try {
                    Result.Builder voidResult = Result.builder().output((Object)"").length(0L);
                    r.getAttributes().ifPresent(arg_0 -> ((Result.Builder)voidResult).attributes(arg_0));
                    r.getMediaType().ifPresent(arg_0 -> ((Result.Builder)voidResult).mediaType(arg_0));
                    r.getAttributesMediaType().ifPresent(arg_0 -> ((Result.Builder)voidResult).attributesMediaType(arg_0));
                    future.complete(voidResult.build());
                }
                finally {
                    RestSdkUtils.closeStream(r.getOutput());
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Result<InputStream, HttpResponseAttributes>> request(RestRequestBuilder requestBuilder, int responseTimeoutMillis, MediaType defaultResponseMediaType, StreamingHelper streamingHelper) {
        CompletableFuture<Result<InputStream, HttpResponseAttributes>> future = new CompletableFuture<Result<InputStream, HttpResponseAttributes>>();
        HttpRequest request = this.getHttpRequest(requestBuilder);
        try {
            this.httpClient.sendAsync(request, HttpRequestOptions.builder().responseTimeout(responseTimeoutMillis).followsRedirect(true).authentication(this.authentication).build()).whenComplete((response, t) -> {
                try {
                    if (t != null) {
                        this.handleRequestException((Throwable)t, request, future);
                    } else {
                        this.handleResponse((HttpResponse)response, request, requestBuilder.getUriParams(), defaultResponseMediaType, future, streamingHelper, this.buildHttpResponseInterceptor(requestBuilder.getResponseInterceptorDescriptor(), defaultResponseMediaType, streamingHelper, this.expressionLanguage));
                    }
                }
                catch (MuleRuntimeException e) {
                    future.completeExceptionally(e);
                }
                catch (Throwable e) {
                    future.completeExceptionally(new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unhandled exception on completing send async."), e));
                }
            });
        }
        catch (Throwable t2) {
            this.handleRequestException(t2, request, future);
        }
        return future;
    }

    private HttpResponseInterceptor buildHttpResponseInterceptor(HttpResponseInterceptorDescriptor descriptor, MediaType defaultResponseMediaType, StreamingHelper streamingHelper, ExpressionLanguage expressionLanguage) {
        if (descriptor == null) {
            return null;
        }
        return this.httpResponseInterceptorFactory.newHttpResponseInterceptor(descriptor, defaultResponseMediaType, streamingHelper, expressionLanguage);
    }

    @Override
    public ConnectionValidationResult validate(ConnectionValidationSettings settings, int responseTimeoutMillis) {
        HttpResponse response;
        RestRequestBuilder requestBuilder = new RestRequestBuilder(this.getBaseUri(), settings.getTestConnectionPath(), settings.getHttpMethod());
        try {
            response = this.httpClient.send(this.getHttpRequest(requestBuilder), HttpRequestOptions.builder().responseTimeout(responseTimeoutMillis).followsRedirect(true).authentication(this.authentication).build());
        }
        catch (TimeoutException e) {
            return ConnectionValidationUtils.connectionValidationResult((Exception)new ModuleException(e.getMessage(), (ErrorTypeDefinition)RestError.TIMEOUT, (Throwable)e));
        }
        catch (Throwable t) {
            return ConnectionValidationUtils.connectionValidationResult((Exception)new ModuleException(t.getMessage(), (ErrorTypeDefinition)RestError.CONNECTIVITY, t));
        }
        return ConnectionValidator.validateConnectionResponse(response, settings);
    }

    private HttpRequest getHttpRequest(RestRequestBuilder requestBuilder) {
        MultiMap<String, String> headers = requestBuilder.getHeaders();
        MultiMap<String, String> queryParams = requestBuilder.getQueryParams();
        this.merge(this.defaultHeaders, defHeader -> !headers.containsKey(defHeader), requestBuilder::addHeader);
        this.merge(this.defaultQueryParams, defQuery -> !queryParams.containsKey(defQuery), requestBuilder::addQueryParam);
        return this.buildRequest(requestBuilder);
    }

    private void handleResponse(HttpResponse response, HttpRequest request, Map<String, String> uriParams, MediaType defaultResponseMediaType, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper, HttpResponseInterceptor onHttpResponseInterceptor) {
        RestError error = RestError.getErrorByCode((response = this.postProcessResponse(response, request, uriParams, onHttpResponseInterceptor, streamingHelper)).getStatusCode()).orElse(null);
        if (error != null) {
            this.handleResponseError(response, defaultResponseMediaType, future, streamingHelper, error);
        } else {
            future.complete(this.toResult(response, false, defaultResponseMediaType, streamingHelper));
        }
    }

    private HttpResponse postProcessResponse(HttpResponse response, HttpRequest request, Map<String, String> uriParams, HttpResponseInterceptor httpResponseInterceptor, StreamingHelper streamingHelper) {
        if (httpResponseInterceptor == null) {
            return response;
        }
        DefaultHttpRequest interceptionHttpRequest = new DefaultHttpRequest(request, uriParams);
        try {
            return httpResponseInterceptor.intercept(interceptionHttpRequest, response);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"There was an error while executing the HttpResponseInterceptor for the server's response"), (Throwable)e);
        }
    }

    protected void handleResponseError(HttpResponse response, MediaType defaultResponseMediaType, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper, RestError error) {
        future.completeExceptionally((Throwable)((Object)new RequestException(error, this.toResult(response, true, defaultResponseMediaType, streamingHelper))));
    }

    private void handleRequestException(Throwable t, HttpRequest request, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future) {
        this.checkIfRemotelyClosed(t, request);
        RestError error = t instanceof TimeoutException ? RestError.TIMEOUT : RestError.CONNECTIVITY;
        future.completeExceptionally((Throwable)new ModuleException(t.getMessage(), (ErrorTypeDefinition)error, t));
    }

    protected <T> Result<T, HttpResponseAttributes> toResult(HttpResponse response, boolean isError, MediaType defaultResponseMediaType, StreamingHelper streamingHelper) {
        Result.Builder builder = Result.builder();
        HttpEntity entity = response.getEntity();
        InputStream content = entity.getContent();
        if (isError) {
            content = streamingHelper.resolveCursorStreamProvider(content);
        }
        if (content instanceof CursorStream) {
            content = FromCursorProviderInputStream.of((CursorStreamProvider)((CursorStream)content).getProvider());
        }
        builder.output((Object)content);
        entity.getBytesLength().ifPresent(arg_0 -> ((Result.Builder)builder).length(arg_0));
        MediaType contentType = RestSdkUtils.getMediaType(response, defaultResponseMediaType);
        builder.mediaType(contentType);
        builder.attributes((Object)this.toAttributes(response)).attributesMediaType(MediaType.APPLICATION_JAVA);
        return builder.build();
    }

    protected HttpRequest buildRequest(RestRequestBuilder requestBuilder) {
        return requestBuilder.build();
    }

    protected HttpResponseAttributes toAttributes(HttpResponse response) {
        return new HttpResponseAttributes(response.getStatusCode(), response.getReasonPhrase(), (MultiMap<String, String>)response.getHeaders());
    }

    protected void beforeStop() {
    }

    protected void afterStop() {
    }

    private void checkIfRemotelyClosed(Throwable exception, HttpRequest request) {
        if ("https".equals(request.getUri().getScheme()) && RestSdkUtils.containsIgnoreCase(exception.getMessage(), REMOTELY_CLOSED)) {
            LOGGER.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public final void stop() {
        try {
            this.beforeStop();
        }
        catch (Throwable t) {
            LOGGER.warn(String.format("Exception found before stopping config '%s'", this.configName), t);
        }
        try {
            this.afterStop();
        }
        catch (Throwable t) {
            LOGGER.warn(String.format("Exception found after stopping config '%s'", this.configName), t);
        }
    }

    @Override
    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    private MultiMap<String, String> nullSafe(MultiMap<String, String> multiMap) {
        return multiMap != null ? multiMap : new MultiMap();
    }

    protected ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }
}

