/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.common;

import com.mulesoft.connectivity.rest.commons.api.binding.HttpRequestBinding;
import com.mulesoft.connectivity.rest.commons.api.binding.ParameterBinding;
import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.common.TypeParameterResolverUtil;
import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.api.dw.HttpResponseDWBinding;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.EvaluationContextBuilderFactory;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.ResolverUtil;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.HttpConstants;

public abstract class JsonCustomFieldsHttpMetadataResolver {
    protected abstract String getSchemaPath();

    protected abstract String getMethod();

    protected abstract String getPath();

    protected abstract String getTransformationScript();

    protected abstract String getSelector();

    public MetadataType resolveMetadataType(MetadataContext metadataContext, Object key) throws MetadataResolvingException {
        try {
            RestConnection connection = this.getConnection(metadataContext);
            RestConfiguration configuration = this.getConfiguration(metadataContext);
            RestRequestBuilder requestBuilder = this.getRestRequestBuilder(key, connection, configuration);
            String customFieldSchema = this.doRequestAndTransformSchema(connection, configuration, requestBuilder);
            MetadataType metadataType = TypeParameterResolverUtil.resolveType(configuration.getExpressionLanguageMetadataService(), customFieldSchema, this.getSelector(), this.getSchemaPath(), MetadataFormat.JSON);
            return metadataType;
        }
        catch (Exception e) {
            throw new MetadataResolvingException("Error generating metadata output type", FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    private String doRequestAndTransformSchema(RestConnection connection, RestConfiguration configuration, RestRequestBuilder requestBuilder) {
        Result<TypedValue<String>, HttpResponseAttributes> response = RequestStreamingUtils.doRequestAndConsumeString(connection, configuration, requestBuilder, MediaType.APPLICATION_JSON, configuration.getExpressionLanguage());
        HttpResponseDWBinding httpResponseDWBinding = new HttpResponseDWBinding((TypedValue<String>)((TypedValue)response.getOutput()), response.getAttributes().orElse(null));
        return configuration.getExpressionLanguage().evaluate(this.getTransformationScript(), DataType.JSON_STRING, BindingContext.builder().addBinding("payload", (TypedValue)response.getOutput()).addBinding(DWBindings.RESPONSE.getBinding(), TypedValue.of((Object)httpResponseDWBinding)).build()).getValue().toString();
    }

    private RestRequestBuilder getRestRequestBuilder(Object key, RestConnection connection, RestConfiguration configuration) {
        RestRequestBuilder restRequestBuilder = new RestRequestBuilder(connection.getBaseUri(), this.getPath(), HttpConstants.Method.valueOf((String)this.getMethod()));
        if (configuration.getResponseInterceptorDescriptor() != null) {
            restRequestBuilder.responseInterceptorDescriptor(configuration.getResponseInterceptorDescriptor());
        }
        EvaluationContext parentEvaluationContext = ResolverUtil.createParentEvaluationContext(null, configuration, connection, configuration.getExpressionLanguage());
        EvaluationContextBuilderFactory evaluationContextBuilderFactory = new EvaluationContextBuilderFactory(parentEvaluationContext);
        EvaluationContext evaluationContext = this.buildEvaluationContext(evaluationContextBuilderFactory, key);
        HttpRequestBinding requestBindings = this.getRequestBindings();
        for (ParameterBinding binding : requestBindings.getUriParams()) {
            restRequestBuilder.addUriParam(binding.getKey(), ((TypedValue)evaluationContext.resolve(binding.getValue(), DataType.STRING)).getValue());
        }
        for (ParameterBinding binding : requestBindings.getQueryParams()) {
            restRequestBuilder.addQueryParam(binding.getKey(), ((TypedValue)evaluationContext.resolve(binding.getValue(), DataType.STRING)).getValue());
        }
        for (ParameterBinding binding : requestBindings.getHeaders()) {
            restRequestBuilder.addHeader(binding.getKey(), ((TypedValue)evaluationContext.resolve(binding.getValue(), DataType.STRING)).getValue());
        }
        return restRequestBuilder;
    }

    protected HttpRequestBinding getRequestBindings() {
        return new HttpRequestBinding();
    }

    protected EvaluationContext buildEvaluationContext(EvaluationContextBuilderFactory evaluationContextBuilderFactory, Object key) {
        return evaluationContextBuilderFactory.emptyContextBuilder().build();
    }

    private RestConnection getConnection(MetadataContext context) throws ConnectionException {
        return (RestConnection)context.getConnection().orElseThrow(() -> new ConnectionException("No connection supplied for metadata generation"));
    }

    protected RestConfiguration getConfiguration(MetadataContext context) throws MetadataResolvingException {
        return (RestConfiguration)context.getConfig().orElseThrow(() -> new MetadataResolvingException("No configuration supplied for metadata generation", FailureCode.INVALID_CONFIGURATION));
    }
}

