/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.source;

import com.mulesoft.connectivity.rest.commons.api.backoff.RandomizedExponentialBackoffCaller;
import com.mulesoft.connectivity.rest.commons.api.backoff.Result;
import com.mulesoft.connectivity.rest.commons.api.backoff.RetriableCallerConfiguration;
import com.mulesoft.connectivity.rest.commons.api.binding.HttpRequestBinding;
import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.api.dw.HttpResponseDWBinding;
import com.mulesoft.connectivity.rest.commons.api.error.RequestException;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.error.SourceStartingException;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.internal.util.DwUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaginatedBasedRestPollingSource
extends PollingSource<InputStream, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaginatedBasedRestPollingSource.class);
    private static final String ITEM_BINDING = "item";
    @Config
    protected RestConfiguration config;
    @Connection
    private ConnectionProvider<RestConnection> connectionProvider;
    @Inject
    private ExpressionLanguage expressionLanguage;
    protected RestConnection connection;
    protected final String watermarkExpression;
    protected final String identityExpression;
    protected final String requestBodyExpression;
    protected final String eventExpression;
    protected final String startValueExpression;
    private TypedValue<?> startValue;
    private Map<String, Object> parameterBindings;
    protected RestPagingProvider baseOperationPagingProvider;
    @Parameter
    @Optional(defaultValue="1")
    private int restSdk_maxRetries;
    @Parameter
    @Optional(defaultValue="900000")
    private int restSdk_maxWaitingValue;
    @ParameterGroup(name="Connector Overrides")
    protected ConfigurationOverrides overrides;
    private RandomizedExponentialBackoffCaller<RestPagingProvider.PaginationResponse> randomizedExponentialBackoffCaller;

    public PaginatedBasedRestPollingSource(String watermarkExpression, String identityExpression, String requestBodyExpression, String eventExpression, String startValueExpression) {
        this.watermarkExpression = watermarkExpression;
        this.identityExpression = identityExpression;
        this.requestBodyExpression = requestBodyExpression;
        this.eventExpression = eventExpression;
        this.startValueExpression = startValueExpression;
    }

    protected void doStart() throws MuleException {
        this.validateExpression(this.watermarkExpression);
        this.validateExpression(this.identityExpression);
        this.validateExpression(this.requestBodyExpression);
        this.validateExpression(this.startValueExpression);
        for (String bindingExpression : this.getParameterBinding().getAllBindingExpressions()) {
            if (!DwUtils.isExpression(bindingExpression)) continue;
            this.validateExpression(bindingExpression);
        }
        this.connection = (RestConnection)this.connectionProvider.connect();
        this.evaluateStartValue();
        this.parameterBindings = StreamUtils.resolveCursorProvider(this.getParameterValues());
        this.randomizedExponentialBackoffCaller = new RandomizedExponentialBackoffCaller<RestPagingProvider.PaginationResponse>(new RetriableCallerConfiguration(this.restSdk_maxRetries, this.restSdk_maxWaitingValue)){

            @Override
            public boolean isRetriable(Result result) {
                return result.isError() && result.getResult().getClass().equals(RequestException.class) && ((RequestException)((Object)result.getResult())).getType().equals((Object)RestError.TOO_MANY_REQUESTS);
            }
        };
        this.doInstancesStart();
    }

    protected abstract void doInstancesStart();

    private void evaluateStartValue() {
        BindingContext.Builder builder = BindingContext.builder();
        this.addParametersBinding(builder);
        this.addConfigAndConnectionBinding(builder);
        BindingContext bindingContext = builder.build();
        this.startValue = this.getStartValue(bindingContext);
    }

    protected TypedValue<?> getStartValue(BindingContext bindingContext) {
        return this.getExpressionLanguage().evaluate(this.startValueExpression, bindingContext);
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    protected abstract HttpRequestBinding getParameterBinding();

    protected abstract Map<String, Object> getParameterValues();

    protected abstract String getPathTemplate();

    protected String getId() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected RestConfiguration getConfig() {
        return this.config;
    }

    protected ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    protected RestConnection getConnection() {
        return this.connection;
    }

    private RestPagingProvider.PaginationResponse getItemsByPageBackoff(PollContext<InputStream, Object> pollContext) {
        try {
            return this.randomizedExponentialBackoffCaller.call(() -> this.getBackoffResultGetCaller(pollContext));
        }
        catch (InterruptedException e) {
            LOGGER.warn(String.format("Trigger '%s': Mule runtime exception found while executing poll: '%s'", this.getId(), e.getMessage()), (Throwable)e);
            this.baseOperationPagingProvider.cleanPagingAttributes();
            return new RestPagingProvider.PaginationResponse(null, null, Collections.emptyList());
        }
    }

    private Result getBackoffResultGetCaller(PollContext<InputStream, Object> pollContext) {
        try {
            return new Result<RestPagingProvider.PaginationResponse>(this.baseOperationPagingProvider.getFullPage(this.connection));
        }
        catch (AccessTokenExpiredException e) {
            this.baseOperationPagingProvider.cleanPagingAttributes();
            LOGGER.info(String.format("Trigger '%s': about to notify access token expiration to runtime...", this.getId()), (Throwable)e);
            pollContext.onConnectionException(new ConnectionException((Throwable)e));
            LOGGER.info(String.format("Trigger '%s': access token expiration notified to runtime.", this.getId()), (Throwable)e);
            return new Result<AccessTokenExpiredException>(e);
        }
        catch (RequestException e) {
            return new Result<RequestException>(e);
        }
        catch (MuleRuntimeException e) {
            this.baseOperationPagingProvider.cleanPagingAttributes();
            LOGGER.warn(String.format("Trigger '%s': Mule runtime exception found while executing poll: '%s'", this.getId(), e.getMessage()), (Throwable)e);
            return new Result<MuleRuntimeException>(e);
        }
    }

    public void poll(PollContext<InputStream, Object> pollContext) {
        Serializable watermark = pollContext.getWatermark().orElse(null);
        RestPagingProvider.PaginationResponse paginationResponse = this.getItemsByPageBackoff(pollContext);
        while (!paginationResponse.getItems().isEmpty()) {
            for (TypedValue<String> item : paginationResponse.getItems()) {
                pollContext.accept(this.getPollItemConsumer(paginationResponse.getFullPage(), paginationResponse.getAttributes(), watermark, item));
            }
            paginationResponse = this.getItemsByPageBackoff(pollContext);
        }
        this.baseOperationPagingProvider.cleanPagingAttributes();
    }

    private Consumer<PollContext.PollItem<InputStream, Object>> getPollItemConsumer(TypedValue<String> fullPage, HttpResponseAttributes attributes, Serializable watermark, TypedValue<String> item) {
        return pollItem -> {
            TypedValue<InputStream> inputStreamTypedValue = this.getEvent(item);
            org.mule.runtime.extension.api.runtime.operation.Result itemResult = org.mule.runtime.extension.api.runtime.operation.Result.builder().output(inputStreamTypedValue.getValue()).mediaType(inputStreamTypedValue.getDataType().getMediaType()).build();
            pollItem.setResult(itemResult);
            if (RestSdkUtils.isNotBlank(this.watermarkExpression)) {
                pollItem.setWatermark(this.getItemWatermark(fullPage, attributes, watermark, item));
            }
            if (RestSdkUtils.isNotBlank(this.identityExpression)) {
                pollItem.setId(this.getIdentity(fullPage, attributes, watermark, item));
            }
        };
    }

    protected DataType getWatermarkDataType() {
        return DataType.STRING;
    }

    private Serializable getItemWatermark(TypedValue<String> fullPage, HttpResponseAttributes attributes, Serializable currentWatermark, TypedValue<String> item) {
        return (Serializable)this.expressionLanguage.evaluate(this.watermarkExpression, this.getWatermarkDataType(), this.buildContext(fullPage, attributes, currentWatermark, item)).getValue();
    }

    private String getIdentity(TypedValue<String> fullPage, HttpResponseAttributes attributes, Serializable currentWatermark, TypedValue<String> item) {
        return (String)this.expressionLanguage.evaluate(this.identityExpression, DataType.STRING, this.buildContext(fullPage, attributes, currentWatermark, item)).getValue();
    }

    private TypedValue<InputStream> getEvent(TypedValue<String> item) {
        if (this.eventExpression != null) {
            TypedValue eventTransform = this.expressionLanguage.evaluate(this.eventExpression, item.getDataType(), BindingContext.builder().addBinding(ITEM_BINDING, item).build());
            item = new TypedValue((Object)eventTransform.getValue().toString(), eventTransform.getDataType());
        }
        return new TypedValue((Object)new ByteArrayInputStream(((String)item.getValue()).getBytes()), item.getDataType());
    }

    private void validateExpression(String expression) throws SourceStartingException {
        if (RestSdkUtils.isBlank(expression)) {
            return;
        }
        ValidationResult validationResult = this.expressionLanguage.validate(expression);
        if (!validationResult.isSuccess()) {
            throw new SourceStartingException(String.format("Expression is not valid: %s", expression));
        }
    }

    private BindingContext buildContext(TypedValue<String> fullPage, HttpResponseAttributes attributes, Serializable currentWatermark, TypedValue<String> item) {
        HttpResponseDWBinding httpResponseDWBinding = new HttpResponseDWBinding(fullPage, attributes);
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", fullPage).addBinding(DWBindings.RESPONSE.getBinding(), TypedValue.of((Object)httpResponseDWBinding)).addBinding("watermark", TypedValue.of((Object)currentWatermark)).addBinding("startValue", this.startValue);
        this.addParametersBinding(builder);
        this.addConfigAndConnectionBinding(builder);
        if (item != null) {
            builder.addBinding(ITEM_BINDING, item);
        }
        return builder.build();
    }

    private void addParametersBinding(BindingContext.Builder builder) {
        builder.addBinding("parameters", TypedValue.of(this.parameterBindings));
    }

    private void addConfigAndConnectionBinding(BindingContext.Builder builder) {
        builder.addBinding("configuration", RestSdkUtils.getTypedValueOrNull(this.config.getBindings())).addBinding("connection", RestSdkUtils.getTypedValueOrNull(this.connection.getBindings()));
    }

    public void onRejectedItem(org.mule.runtime.extension.api.runtime.operation.Result<InputStream, Object> result, SourceCallbackContext callbackContext) {
        if (result.getOutput() != null) {
            RestSdkUtils.closeStream(result.getOutput());
        }
        LOGGER.debug("Item Rejected");
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

