/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.interception.expression;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpRequest;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.streaming.StreamingHelper;
import com.mulesoft.connectivity.rest.commons.internal.interception.model.HttpEntityCursorStreamProviderBased;
import com.mulesoft.connectivity.rest.commons.internal.interception.model.RepeatableHttpResponse;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ExpressionLanguageSession;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public abstract class BaseExpressionHttpResponseInterceptor
implements HttpResponseInterceptor {
    private MediaType defaultResponseMediaType;
    private ExpressionLanguage expressionLanguage;
    protected StreamingHelper streamingHelper;

    protected BaseExpressionHttpResponseInterceptor(MediaType defaultResponseMediaType, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper) {
        Objects.requireNonNull(defaultResponseMediaType);
        Objects.requireNonNull(expressionLanguage);
        Objects.requireNonNull(streamingHelper);
        this.defaultResponseMediaType = defaultResponseMediaType;
        this.expressionLanguage = expressionLanguage;
        this.streamingHelper = streamingHelper;
    }

    private BindingContext createBindingContext(HttpRequest httpRequest, RepeatableHttpResponse httpResponse) {
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        bindingContextBuilder.addBinding(DWBindings.REQUEST.getBinding(), TypedValue.of((Object)httpRequest));
        MediaType mediaType = this.getMediaType(httpResponse);
        bindingContextBuilder.addBinding(DWBindings.STATUS_CODE.getBinding(), TypedValue.of((Object)httpResponse.getStatusCode()));
        bindingContextBuilder.addBinding(DWBindings.REASON_PHRASE.getBinding(), TypedValue.of((Object)httpResponse.getReasonPhrase()));
        bindingContextBuilder.addBinding(DWBindings.HEADERS.getBinding(), TypedValue.of(httpResponse.getHeaders()));
        bindingContextBuilder.addBinding(DWBindings.BODY.getBinding(), new TypedValue((Object)((HttpEntityCursorStreamProviderBased)httpResponse.getEntity()).getCursorStreamProvider(), DataType.builder().mediaType(mediaType).charset(RestSdkUtils.resolveCharset(Optional.empty(), mediaType)).build()));
        bindingContextBuilder.addBinding(DWBindings.MEDIATYPE.getBinding(), TypedValue.of((Object)mediaType.toRfcString()));
        return bindingContextBuilder.build();
    }

    protected MediaType getMediaType(HttpResponse httpResponse) {
        return RestSdkUtils.getMediaType(httpResponse, this.defaultResponseMediaType);
    }

    protected <T> TypedValue<T> evaluate(String expression, ExpressionLanguageSession session, DataType dataType) {
        return this.doEvaluate(expression, session, dataType);
    }

    private <T> TypedValue<T> doEvaluate(String expression, ExpressionLanguageSession session, DataType dataType) {
        return session.evaluate(expression, dataType);
    }

    @Override
    public HttpResponse intercept(HttpRequest httpRequest, HttpResponse httpResponse) {
        RepeatableHttpResponse repeatableHttpResponse = RepeatableHttpResponse.newRepeatableHttpResponse(httpResponse, this.streamingHelper);
        BindingContext bindingContext = this.createBindingContext(httpRequest, repeatableHttpResponse);
        try (ExpressionLanguageSession session = this.expressionLanguage.openSession(bindingContext);){
            RepeatableHttpResponse repeatableHttpResponse2 = this.doIntercept(httpRequest, repeatableHttpResponse, session, bindingContext, this.expressionLanguage);
            return repeatableHttpResponse2;
        }
    }

    protected abstract RepeatableHttpResponse doIntercept(HttpRequest var1, RepeatableHttpResponse var2, ExpressionLanguageSession var3, BindingContext var4, ExpressionLanguage var5);
}

