/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.interception.model;

import com.mulesoft.connectivity.rest.commons.api.streaming.StreamingHelper;
import com.mulesoft.connectivity.rest.commons.internal.interception.model.HttpEntityCursorStreamProviderBased;
import java.util.Collection;
import java.util.Objects;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;

@NoExtend
public class RepeatableHttpResponse
implements HttpResponse {
    private HttpResponse response;

    RepeatableHttpResponse(HttpResponse response) {
        Objects.requireNonNull(response, "response cannot be null.");
        this.response = response;
    }

    public static RepeatableHttpResponse newRepeatableHttpResponse(HttpResponse response, StreamingHelper streamingHelper) {
        if (response instanceof RepeatableHttpResponse) {
            return (RepeatableHttpResponse)response;
        }
        return new RepeatableHttpResponse(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(response.getStatusCode())).reasonPhrase(response.getReasonPhrase()).headers(response.getHeaders())).entity(RepeatableHttpResponse.toRepeatableStreamingHttpEntity(response, streamingHelper))).build());
    }

    private static HttpEntity toRepeatableStreamingHttpEntity(HttpResponse response, StreamingHelper streamingHelper) {
        HttpEntity entity = response.getEntity();
        if (entity instanceof HttpEntityCursorStreamProviderBased && !((HttpEntityCursorStreamProviderBased)entity).getCursorStreamProvider().isClosed()) {
            return entity;
        }
        CursorStreamProvider payload = streamingHelper.resolveCursorStreamProvider(entity.getContent());
        return new HttpEntityCursorStreamProviderBased(payload, entity.getBytesLength());
    }

    public void close() {
        ((HttpEntityCursorStreamProviderBased)this.getEntity()).close();
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    public HttpEntity getEntity() {
        return this.response.getEntity();
    }

    public Collection<String> getHeaderNames() {
        return this.response.getHeaderNames();
    }

    public boolean containsHeader(String headerName) {
        return this.response.containsHeader(headerName);
    }

    public String getHeaderValue(String headerName) {
        return this.response.getHeaderValue(headerName);
    }

    @Deprecated
    public String getHeaderValueIgnoreCase(String headerName) {
        return this.response.getHeaderValueIgnoreCase(headerName);
    }

    public Collection<String> getHeaderValues(String headerName) {
        return this.response.getHeaderValues(headerName);
    }

    @Deprecated
    public Collection<String> getHeaderValuesIgnoreCase(String headerName) {
        return this.response.getHeaderValuesIgnoreCase(headerName);
    }

    public MultiMap<String, String> getHeaders() {
        return this.response.getHeaders();
    }

    public HttpEntityCursorStreamProviderBased getRepeatableEntity() {
        return (HttpEntityCursorStreamProviderBased)this.getEntity();
    }
}

