/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler;
import java.util.HashMap;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;

public class StringHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof StringSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager, ParsingContext parsingContext) {
        StringSchema stringSchema = (StringSchema)schema;
        StringTypeBuilder stringType = root.stringType();
        String formatName = stringSchema.getFormatValidator().formatName();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!FormatValidator.NONE.formatName().equals(formatName)) {
            properties.put("format", formatName);
        }
        this.processTracing(schema, (WithAnnotation)stringType, handlerManager, parsingContext, properties);
        Integer min = null;
        Integer max = null;
        if (stringSchema.getMinLength() != null && stringSchema.getMinLength() > 0) {
            min = stringSchema.getMinLength();
        }
        if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() > 0) {
            max = stringSchema.getMaxLength();
        }
        if (min != null || max != null) {
            stringType.boundary((Number)min, max);
        }
        if (stringSchema.getPattern() != null) {
            stringType.pattern(stringSchema.getPattern().toString());
        }
        return stringType;
    }
}

