/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.multipart;

import com.mulesoft.connectivity.rest.commons.api.multipart.MultipartPayloadBuilder;
import com.mulesoft.connectivity.rest.commons.internal.multipart.FilePart;
import com.mulesoft.connectivity.rest.commons.internal.multipart.Part;
import com.mulesoft.connectivity.rest.commons.internal.multipart.PartVisitor;
import com.mulesoft.connectivity.rest.commons.internal.util.DwUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;

public class DWMultipartPayloadBuilder
implements MultipartPayloadBuilder {
    private final ExpressionLanguage expressionLanguage;
    private final List<Part> parts = new ArrayList<Part>();
    private String boundary = null;

    public DWMultipartPayloadBuilder(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public MultipartPayloadBuilder addPart(String partName, TypedValue<InputStream> content) {
        this.parts.add(new Part(partName, content));
        return this;
    }

    @Override
    public MultipartPayloadBuilder addFilePart(String partName, String filename, TypedValue<InputStream> content) {
        this.parts.add(new FilePart(partName, filename, content));
        return this;
    }

    @Override
    public MultipartPayloadBuilder setBoundary(String boundary) {
        this.boundary = boundary;
        return this;
    }

    @Override
    public TypedValue<InputStream> build() {
        return this.doBuild(true);
    }

    public TypedValue<CursorStreamProvider> asCursorStreamProvider() {
        return this.doBuild(false);
    }

    private TypedValue doBuild(boolean deferred) {
        StringBuilder builder = new StringBuilder("%dw 2.0\noutput multipart/form-data");
        if (this.boundary != null) {
            builder.append(" boundary='").append(this.boundary).append("'");
        }
        if (deferred) {
            if (this.boundary != null) {
                builder.append(",");
            }
            builder.append(" deferred=true");
        }
        builder.append("\n---\n{\nparts: {\n");
        BuilderVisitor visitor = new BuilderVisitor(builder);
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        this.parts.forEach(p -> {
            visitor.addPartDwIdentifier((Part)p, DwUtils.getDwIdentifier(p.getName()));
            p.accept(visitor);
            bindingContextBuilder.addBinding(visitor.getPartDwIdentifier((Part)p), p.getContent());
        });
        builder.append("\n}\n}");
        return this.expressionLanguage.evaluate(builder.toString(), bindingContextBuilder.build());
    }

    private static class BuilderVisitor
    implements PartVisitor {
        private final StringBuilder builder;
        private boolean partBuilt = false;
        private Map<Part, String> partDwIdentifier;

        public BuilderVisitor(StringBuilder builder) {
            this.builder = builder;
            this.partDwIdentifier = new HashMap<Part, String>();
        }

        public void addPartDwIdentifier(Part part, String dwIdentifier) {
            this.partDwIdentifier.put(part, dwIdentifier);
        }

        public String getPartDwIdentifier(Part part) {
            return this.partDwIdentifier.get(part);
        }

        @Override
        public void visit(Part part) {
            this.buildPart(part, Collections.emptyList());
        }

        @Override
        public void visit(FilePart part) {
            String header = "\"Content-Disposition\": {\n" + "name: \"" + part.getName() + "\",\n" + "filename: \"" + part.getFilename() + "\"\n}";
            this.buildPart(part, Collections.singletonList(header));
        }

        private void buildPart(Part part, List<String> headers) {
            if (this.partBuilt) {
                this.builder.append(",\n");
            }
            this.builder.append("\"").append(part.getName()).append("\": {\n").append("headers: {\n");
            boolean headersAdded = false;
            for (String header : headers) {
                if (headersAdded) {
                    this.builder.append(",\n");
                }
                this.builder.append(header);
                headersAdded = true;
            }
            if (headersAdded) {
                this.builder.append(",\n");
            }
            this.builder.append("\"Content-Type\": \"").append(part.getContent().getDataType().getMediaType().toRfcString().replace("\"", "\\\"")).append("\"\n},\ncontent: ").append(this.getPartDwIdentifier(part)).append("\n}");
            this.partBuilt = true;
        }
    }
}

