/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.multipart;

import org.mule.runtime.api.metadata.TypedValue;

import java.io.InputStream;

/**
 * Generic representation of an Http Part.
 *
 * @since 1.0
 */
public class Part {

  protected final String name;
  protected final TypedValue<InputStream> content;

  public Part(String name, TypedValue<InputStream> content) {
    this.name = name;
    this.content = content;
  }

  public String getName() {
    return name;
  }

  public TypedValue<InputStream> getContent() {
    return content;
  }

  public void accept(PartVisitor visitor) {
    visitor.visit(this);
  }
}
