/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.sampledata;

import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.sdk.api.runtime.operation.Result;

import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.internal.adapter.SdkResultAdapter;

import java.io.InputStream;

/**
 * A base implementation of sample data for operations and triggers.
 *
 * @since 1.0
 */
public abstract class RestSampleDataProvider extends BaseRestSampleDataProvider<InputStream, HttpResponseAttributes> {

  @Override
  protected Result<InputStream, HttpResponseAttributes> transformOutputToResult(Object output) {

    if (output instanceof TypedValue) {
      TypedValue<?> tValue = (TypedValue<?>) output;
      output = Result.builder()
          .output(new TypedValue<>(tValue.getValue().toString(),
                                   DataType.builder().type(Object.class).mediaType(tValue.getDataType().getMediaType()).build()))
          .mediaType(tValue.getDataType().getMediaType())
          .build();
    }

    return SdkResultAdapter.from(output);
  }
}
