/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.common;

import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.SimpleEvaluationContext;

import java.util.HashMap;
import java.util.Map;

/**
 * Evaluation context builder for an operation context.
 *
 * @since 1.0
 */
public class OperationEvaluationContextBuilder extends EvaluationContextBuilder {

  private final static String KEY_HEADERS = "header";
  private final static String KEY_URI_PARAMETERS = "uriParameter";
  private final static String KEY_QUERY_PARAMETERS = "queryParameter";

  private final Map<String, Object> headers = new HashMap<>();
  private final Map<String, Object> uriParameters = new HashMap<>();
  private final Map<String, Object> queryParameters = new HashMap<>();

  public OperationEvaluationContextBuilder(EvaluationContext globalEvaluationContext) {
    super(globalEvaluationContext);
  }

  /**
   * Adds an URI parameter to the evaluation context being built. These get later accessed via
   * '{@link #KEY_URI_PARAMETERS}.{name}'
   */
  public OperationEvaluationContextBuilder uriParameter(String name, Object value) {
    setKeyValue(name, value, uriParameters);
    return this;
  }

  /**
   * Adds an query parameter to the evaluation context being built. These get later accessed via
   * '{@link #KEY_QUERY_PARAMETERS}.{name}'
   */
  public OperationEvaluationContextBuilder queryParameter(String name, Object value) {
    setKeyValue(name, value, queryParameters);
    return this;
  }

  /**
   * Adds a header to the evaluation context being built. These get later accessed via '{@link #KEY_HEADERS}.{name}'
   */
  public OperationEvaluationContextBuilder header(String name, Object value) {
    setKeyValue(name, value, headers);
    return this;
  }

  public EvaluationContext build() {
    final EvaluationContext evaluationContext = new SimpleEvaluationContext(buildGlobalEvaluationContext().orElse(null));
    evaluationContext.define(KEY_HEADERS, headers);
    evaluationContext.define(KEY_URI_PARAMETERS, uriParameters);
    evaluationContext.define(KEY_QUERY_PARAMETERS, queryParameters);
    return evaluationContext;
  }
}
