/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.common;

/**
 * An evaluable expression with a language and content.
 *
 * @since 1.0
 */
public class Expression implements Evaluable {

  private final String language;
  private final String expression;

  public Expression(String language, String expression) {
    this.language = language;
    this.expression = expression;
  }

  public String getLanguage() {
    return language;
  }

  public String getExpression() {
    return expression;
  }

  @Override
  public String toString() {
    return "Expression{" +
        "language='" + language + '\'' +
        ", expression='" + expression + '\'' +
        '}';
  }

  @Override
  public Object evaluate(EvaluationContext evaluationContext) {
    return evaluationContext.resolve(getExpression());
  }
}
