/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.source;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RequestParameterBinding {
    private final List<Binding> headers = new ArrayList<Binding>();
    private final List<Binding> queryParams = new ArrayList<Binding>();
    private final List<Binding> uriParams = new ArrayList<Binding>();

    public List<Binding> getHeaders() {
        return this.headers;
    }

    public List<Binding> getQueryParams() {
        return this.queryParams;
    }

    public List<Binding> getUriParams() {
        return this.uriParams;
    }

    public List<String> getAllBindingExpressions() {
        List<String> allBindings = this.headers.stream().map(Binding::getValue).collect(Collectors.toList());
        allBindings.addAll(this.queryParams.stream().map(Binding::getValue).collect(Collectors.toList()));
        allBindings.addAll(this.uriParams.stream().map(Binding::getValue).collect(Collectors.toList()));
        return allBindings;
    }

    public void addHeaderBinding(String parameterName, String expression) {
        this.headers.add(new Binding(parameterName, expression));
    }

    public void addQueryParamBinding(String parameterName, String expression) {
        this.queryParams.add(new Binding(parameterName, expression));
    }

    public void addUriParamBinding(String parameterName, String expression) {
        this.uriParams.add(new Binding(parameterName, expression));
    }

    public static class Binding {
        private final String key;
        private final String value;

        public Binding(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

