/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.ExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.ScriptDataExpression;

import java.util.function.Consumer;

/**
 * A fluent builder for a script data expression.
 *
 * @since 1.0
 */
public class ScriptDataExpressionBuilder implements DataExpressionBuilder<ScriptDataExpression> {

  private ExpressionBuilder scriptExpressionBuilder;

  public ScriptDataExpressionBuilder scriptExpression(Consumer<ExpressionBuilder> consumer) {
    final ExpressionBuilder expressionBuilder = new ExpressionBuilder();
    consumer.accept(expressionBuilder);
    scriptExpressionBuilder = expressionBuilder;
    return this;
  }

  private Expression buildScriptExpression() {
    if (scriptExpressionBuilder == null) {
      throw new IllegalStateException("Missing script expression.");
    }
    return scriptExpressionBuilder.build();
  }

  public ScriptDataExpression build() {
    return new ScriptDataExpression(buildScriptExpression());
  }

}
