/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.valueprovider;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.HttpRequestDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.valueprovider.ValueProviderResolverDefinition;

import java.util.function.Consumer;

/**
 * A fluent builder for a value provider definition.
 *
 * @since 1.0
 */
public class ValueProviderResolverDefinitionBuilder extends ResolverDefinitionBuilder<ValueProviderResolverDefinition> {

  private HttpRequestDataExpressionBuilder httpRequestDataExpressionBuilder;
  private String itemExtractionExpression;
  private String itemNameExpression;
  private String itemValueExpression;

  public ValueProviderResolverDefinitionBuilder httpRequest(Consumer<HttpRequestDataExpressionBuilder> consumer) {
    HttpRequestDataExpressionBuilder builder = new HttpRequestDataExpressionBuilder();
    consumer.accept(builder);
    this.httpRequestDataExpressionBuilder = builder;
    return this;
  }

  public ValueProviderResolverDefinitionBuilder itemExtractionExpression(String itemExtractionExpression) {
    this.itemExtractionExpression = itemExtractionExpression;
    return this;
  }

  public ValueProviderResolverDefinitionBuilder itemNameExpression(String itemNameExpression) {
    this.itemNameExpression = itemNameExpression;
    return this;
  }

  public ValueProviderResolverDefinitionBuilder itemValueExpression(String itemValueExpression) {
    this.itemValueExpression = itemValueExpression;
    return this;
  }

  private HttpRequestDataExpression buildHttpRequest() {
    if (httpRequestDataExpressionBuilder == null) {
      throw new IllegalStateException("No HTTP request expression set.");
    }
    return httpRequestDataExpressionBuilder.build();
  }

  private String buildItemExtraction() {
    if (itemExtractionExpression == null) {
      throw new IllegalStateException("No item extraction expression set.");
    }
    return itemExtractionExpression;
  }

  private String buildItemName() {
    return itemNameExpression;
  }

  private String buildItemValue() {
    if (itemValueExpression == null) {
      throw new IllegalStateException("No item value expression set.");
    }
    return itemValueExpression;
  }

  public ValueProviderResolverDefinition build() {
    return new ValueProviderResolverDefinition(buildHttpRequest(), buildItemExtraction(), buildItemName(), buildItemValue());
  }
}
