/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input;

import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;

/**
 * Base class for a {@link PrimitiveInputMetadataResolver} which resolves a java boolean type. This is only meant to be used in
 * generic connectors generated using Rest SDK. For hand-made custom connectors a Java Type can be used instead.
 *
 * @since 1.0
 */
public abstract class BooleanInputMetadataResolver extends PrimitiveInputMetadataResolver {

  @Override
  public MetadataType getStaticMetadata() {
    return BaseTypeBuilder.create(JAVA).booleanType().build();
  }
}
