/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.common;

import java.util.Arrays;

/**
 * A data type.
 *
 * @since 1.0
 */
public enum DataType {

  STRING("string"), INTEGER("integer"), NUMBER("number"), BOOLEAN("boolean"), LOCAL_DATE_TIME("localDateTime"), ZONED_DATE_TIME(
      "zonedDateTime");

  private final String name;

  DataType(String name) {
    this.name = name;
  }

  public static DataType fromString(String name) {
    return Arrays.stream(values())
        .filter(x -> x.name.equalsIgnoreCase(name))
        .findFirst()
        .orElseThrow(IllegalArgumentException::new);
  }
}
