/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;

/**
 * Implementing classes are able to build a data expression.
 * 
 * @param <T> The type of the data expression implementing classes are able to build.
 *
 * @since 1.0
 */
public interface DataExpressionBuilder<T extends DataExpression> {

  /**
   * Gets the built data expression.
   * 
   * @return The built data expression.
   */
  T build();
}
