/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.binding;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.List;

/**
 * Defines the way the operation's http response should be processed using bindings.
 *
 * @since 1.0
 */
public class HttpResponseBinding {

  private final List<ParameterBinding> headers = new ArrayList<>();
  private ParameterBinding body = null;

  public List<ParameterBinding> getHeaders() {
    return headers;
  }

  public ParameterBinding getBody() {
    return body;
  }

  public List<String> getAllBindingExpressions() {
    List<String> allBindings = headers.stream().map(ParameterBinding::getValue).collect(toList());

    if (getBody() != null) {
      allBindings.add(getBody().getValue());
    }

    return allBindings;
  }

  public void addHeaderBinding(String parameterName, String expression) {
    headers.add(new ParameterBinding(parameterName, expression));
  }

  public void setBody(String expression) {
    this.body = new ParameterBinding.BodyBinding(expression);
  }
}
