/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.sdk.api.annotation.semantics.connectivity.DigestAuth;

/**
 * Base class for connection providers secured through the digest security scheme
 *
 * @since 1.0
 */
@DigestAuth
public abstract class DigestConnectionProvider extends BasicAuthenticationConnectionProvider {

  @Override
  protected HttpAuthentication buildAuthentication() {
    return HttpAuthentication.digest(username, password).build();
  }
}
