/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.loadJsonSchema;
import static org.mule.metadata.api.model.MetadataFormat.JSON;
import org.mule.metadata.api.model.MetadataType;

/**
 * Specialization of {@link PagingMetadataResolver} for json schemas
 *
 * @since 1.0
 */
public abstract class PagingJsonMetadataResolver extends PagingMetadataResolver {

  @Override
  protected MetadataType loadSchema(String schemaPath) {
    return loadJsonSchema(getClass().getClassLoader(), schemaPath, JSON);
  }
}
