/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata.handler;

import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import java.util.Collection;

public class CombinedHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof CombinedSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager restHandlerManager,
                               ParsingContext parsingContext) {
    final CombinedSchema combinedSchema = (CombinedSchema) schema;
    final Collection<Schema> subschemas = combinedSchema.getSubschemas();
    if (combinedSchema.getCriterion() == CombinedSchema.ANY_CRITERION
        || combinedSchema.getCriterion() == CombinedSchema.ONE_CRITERION) {
      final UnionTypeBuilder unionType = root.unionType();
      for (Schema subschema : subschemas) {
        unionType.of(restHandlerManager.handle(subschema, parsingContext));
      }
      return unionType;
    } else if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
      final IntersectionTypeBuilder intersectionType = root.intersectionType();
      for (Schema subschema : subschemas) {
        intersectionType.of(restHandlerManager.handle(subschema, parsingContext));
      }
      return intersectionType;
    }
    return root.anyType();
  }
}
