/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers;


import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.ArgumentBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverArgument;

/**
 * A fluent builder for resolver arguments.
 *
 * @since 1.0
 */
public class ResolverArgumentBuilder extends ArgumentBuilder<ResolverArgument, ResolverArgumentBuilder> {

  public ResolverArgumentBuilder(String name) {
    super(name);
  }

  @Override
  protected ResolverArgument build(String name, Expression expression) {
    return new ResolverArgument(name, expression);
  }
}
