/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.internal.util.LinkHeaderUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HypermediaPagingProvider
extends RestPagingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HypermediaPagingProvider.class);
    private final String nextUrlExpression;
    private boolean firstPage = true;
    private String nextUrl;

    public HypermediaPagingProvider(String nextUrlExpression, Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper, String payloadExpression, MediaType defaultMediaType, int responseTimeout) {
        super(requestFactory, expressionLanguage, streamingHelper, payloadExpression, defaultMediaType, responseTimeout);
        this.nextUrlExpression = nextUrlExpression;
    }

    @Override
    protected void configureRequest(RestRequestBuilder requestBuilder) {
        if (!this.firstPage) {
            if (RestSdkUtils.isBlank(this.nextUrl)) {
                this.stopPaging();
                return;
            }
            requestBuilder.setUri(this.nextUrl);
        }
    }

    @Override
    protected void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, HttpResponseAttributes responseAttributes) {
        this.firstPage = false;
        if (RestSdkUtils.isBlank((CharSequence)rawPage.getValue())) {
            this.nextUrl = null;
            this.stopPaging();
        } else {
            this.nextUrl = this.extractNexUrl(rawPage, responseAttributes);
        }
    }

    private String extractNexUrl(TypedValue<String> rawPage, HttpResponseAttributes responseAttributes) {
        try {
            return (String)this.evaluate(rawPage, this.nextUrlExpression, DataType.STRING, responseAttributes).getValue();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to extract nextUrl from expression: %s", this.nextUrlExpression)));
        }
    }

    @Override
    protected BindingContext toBindingContext(TypedValue<?> content, HttpResponseAttributes httpResponseAttributes) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", content);
        if (httpResponseAttributes != null) {
            builder.addBinding("attributes", TypedValue.of((Object)httpResponseAttributes));
            try {
                String linkHeader = (String)httpResponseAttributes.getHeaders().get((Object)"link");
                builder.addBinding("link", TypedValue.of(LinkHeaderUtils.parseLinkHeader(linkHeader)));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse Link header", (Throwable)e);
            }
        }
        return builder.build();
    }
}

