/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import static org.mule.runtime.http.api.HttpHeaders.Names.AUTHORIZATION;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;

import java.util.concurrent.CompletableFuture;

/**
 * Specialization of {@link DefaultRestConnection} for resources protected with OAuth, regardless of the grant type.
 * <p>
 * The main features of this connection are that:
 *
 * <ul>
 * <li>Each instance can only serve one resource owner id. New instances need to be created for each</li>
 * <li>When the service providers responds with a 401 status code, the response {@link CompletableFuture} will be completed with
 * an {@link AccessTokenExpiredException} so that the SDK triggers the refresh token workflow.</li>
 * </ul>
 *
 * @since 1.0
 */
public class BearerRestConnection extends DefaultRestConnection {

  private final String token;

  /**
   * Creates a new instance
   *
   * @param baseUri the service base uri
   * @param configName the name of the config that owns this connection
   * @param httpClient the client to use
   * @param authentication the authentication mechanism to use, or {@code null}
   * @param defaultQueryParams query params to be automatically added to all requests done through this connection
   * @param defaultHeaders headers to be automatically added to all requests done through this connection
   * @param oauthState the {@link OAuthState} for the current connection
   * @param resourceOwnerId the id of the resource owner for this connection
   * @param expressionLanguage
   * @param refreshTokenCondition
   */
  public BearerRestConnection(String baseUri,
                              String configName,
                              HttpClient httpClient,
                              HttpAuthentication authentication,
                              MultiMap<String, String> defaultQueryParams,
                              MultiMap<String, String> defaultHeaders,
                              ExpressionLanguage expressionLanguage,
                              String token) {
    super(baseUri, configName, httpClient, authentication, defaultQueryParams, defaultHeaders, expressionLanguage);
    this.token = token;

  }

  @Override
  protected HttpRequest buildRequest(RestRequestBuilder requestBuilder) {
    requestBuilder.addHeader(AUTHORIZATION, "Bearer " + token);
    return super.buildRequest(requestBuilder);
  }

}
