/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers;

import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.ArgumentBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverArgument;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverReference;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * A fluent builder for resolver references.
 *
 * @since 1.0
 */
public class ResolverReferenceBuilder {

  private String declaration;
  private final List<ResolverArgumentBuilder> arguments;

  public ResolverReferenceBuilder() {
    arguments = new ArrayList<>();
  }

  public ResolverReferenceBuilder declaration(String declaration) {
    this.declaration = declaration;
    return this;
  }

  public ResolverReferenceBuilder argument(String name, Consumer<ResolverArgumentBuilder> consumer) {
    ResolverArgumentBuilder argument = new ResolverArgumentBuilder(name);
    consumer.accept(argument);
    arguments.add(argument);
    return this;
  }

  private String buildDeclaration() {
    if (declaration == null) {
      throw new IllegalStateException("No declaration name set");
    }

    return declaration;
  }

  private List<ResolverArgument> buildArguments() {
    return arguments.stream().map(ArgumentBuilder::build).collect(toList());
  }

  public ResolverReference build() {
    return new ResolverReference(buildDeclaration(), buildArguments());
  }
}
