/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.sampledata;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.outputToByteArray;
import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;
import static org.mule.runtime.core.api.util.IOUtils.closeQuietly;
import static org.mule.runtime.core.api.util.IOUtils.toByteArray;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.sdk.api.runtime.operation.Result;

import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.internal.adapter.SdkResultAdapter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * A base implementation of sample data for operations and triggers.
 *
 * @since 1.0
 */
public abstract class RestSampleDataProvider extends BaseRestSampleDataProvider<InputStream, HttpResponseAttributes> {

  @Override
  protected Result<InputStream, HttpResponseAttributes> transformOutputToResult(Object output) {
    if (output instanceof TypedValue) {
      // RSDK-509: Missing output attributes for this case
      TypedValue<?> tValue = (TypedValue<?>) output;
      output = Result.builder()
          .output(new ByteArrayInputStream(tValue.getValue().toString().getBytes()))
          .mediaType(tValue.getDataType().getMediaType())
          .build();
    }

    Result<?, HttpResponseAttributes> result = SdkResultAdapter.from(output);
    byte[] outputByteArray = outputToByteArray(result);

    return Result.<InputStream, HttpResponseAttributes>builder()
        .output(new ByteArrayInputStream(outputByteArray))
        .mediaType(result.getMediaType().orElse(null))
        .attributes(result.getAttributes().orElse(null))
        .attributesMediaType(result.getAttributesMediaType().orElse(null))
        .build();
  }


}
