/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.queryparam;

import org.mule.runtime.api.util.MultiMap;

/***
 * Formats the query params of a request so they are sent using the desired format.
 *
 * @since 1.0
 */
public interface QueryParamFormatter {

  /***
   * Formats the query params of a request so they are sent using the desired format. For the input multimap every key/value query
   * parameter will have an entry in the multimap. Each value of the @return multimap will be sent as a key/value in the http
   * request.
   *
   * @param queryParams A {@link MultiMap} of query parameters that must be sent in a http request
   * @return A multimap where the query parameters are formatted.
   */
  MultiMap<String, String> format(MultiMap<String, String> queryParams);
}
