/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.source;

import com.mulesoft.connectivity.rest.commons.api.binding.HttpRequestBinding;
import com.mulesoft.connectivity.rest.commons.api.binding.ParameterBinding;
import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.configuration.StreamingType;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.SourceStartingException;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.internal.util.DwUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.FromCursorProviderInputStream;
import com.mulesoft.connectivity.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.SplitPayloadUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestPollingSource
extends PollingSource<InputStream, HttpResponseAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestPollingSource.class);
    @Config
    private RestConfiguration config;
    @Connection
    private ConnectionProvider<RestConnection> connectionProvider;
    @Inject
    private ExpressionLanguage expressionLanguage;
    protected RestConnection connection;
    protected final String watermarkExpression;
    protected final String identityExpression;
    protected final String itemsExpression;
    protected final String requestBodyExpression;

    public RestPollingSource(String itemsExpression, String watermarkExpression, String identityExpression, String requestBodyExpression) {
        Objects.requireNonNull(watermarkExpression);
        Objects.requireNonNull(itemsExpression);
        this.watermarkExpression = watermarkExpression;
        this.identityExpression = identityExpression;
        this.itemsExpression = itemsExpression;
        this.requestBodyExpression = requestBodyExpression;
    }

    protected void doStart() throws MuleException {
        this.validateExpression(this.watermarkExpression);
        this.validateExpression(this.identityExpression);
        this.validateExpression(this.itemsExpression);
        this.validateExpression(this.requestBodyExpression);
        for (String bindingExpression : this.getParameterBinding().getAllBindingExpressions()) {
            if (!DwUtils.isExpression(bindingExpression)) continue;
            this.validateExpression(bindingExpression);
        }
        this.connection = (RestConnection)this.connectionProvider.connect();
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    protected abstract HttpRequestBinding getParameterBinding();

    protected abstract MultiMap<String, TypedValue<?>> getParameterValues();

    protected abstract String getPathTemplate();

    protected abstract RestRequestBuilder getRequestBuilder(String var1);

    protected String getId() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void poll(PollContext<InputStream, HttpResponseAttributes> pollContext) {
        Serializable watermark = pollContext.getWatermark().orElse(null);
        Result<String, HttpResponseAttributes> result = null;
        try {
            result = RequestStreamingUtils.doRequestAndConsumeString(this.connection, this.config, this.getRestRequestBuilder(watermark), this.getDefaultResponseMediaType());
        }
        catch (AccessTokenExpiredException e) {
            LOGGER.info(String.format("Trigger '%s': about to notify access token expiration to runtime...", this.getId()), (Throwable)e);
            pollContext.onConnectionException(new ConnectionException((Throwable)e));
            LOGGER.info(String.format("Trigger '%s': access token expiration notified to runtime.", this.getId()), (Throwable)e);
        }
        catch (MuleRuntimeException e) {
            LOGGER.warn(String.format("Trigger '%s': Mule runtime exception found while executing poll: '%s'", this.getId(), e.getMessage()), (Throwable)e);
        }
        if (result != null) {
            TypedValue<String> fullResponse = RestSdkUtils.toPayloadTypedValue(result);
            HttpResponseAttributes attributes = result.getAttributes().orElse(null);
            for (TypedValue<CursorStreamProvider> item : this.getItems(fullResponse, watermark)) {
                pollContext.accept(this.getPollItemConsumer(watermark, fullResponse, attributes, item));
            }
        }
    }

    private RestRequestBuilder getRestRequestBuilder(Serializable watermark) {
        HttpRequestBinding parameterBinding = this.getParameterBinding();
        RestRequestBuilder requestBuilder = this.getRequestBuilder(this.buildRequestPath(this.getPathTemplate(), parameterBinding.getUriParams(), watermark));
        TypedValue<InputStream> requestBody = this.getRequestBody(watermark);
        if (requestBody != null) {
            requestBuilder.setBody(requestBody, StreamingType.AUTO);
        }
        parameterBinding.getHeaders().forEach(i -> requestBuilder.addHeader(i.getKey(), this.getParameterValue(i.getValue(), watermark)));
        parameterBinding.getQueryParams().forEach(i -> requestBuilder.addQueryParam(i.getKey(), this.getParameterValue(i.getValue(), watermark)));
        return requestBuilder;
    }

    private Consumer<PollContext.PollItem<InputStream, HttpResponseAttributes>> getPollItemConsumer(Serializable watermark, TypedValue<String> fullResponse, HttpResponseAttributes attributes, TypedValue<CursorStreamProvider> item) {
        return pollItem -> {
            TypedValue inputStreamTypedValue = new TypedValue((Object)FromCursorProviderInputStream.of((CursorStreamProvider)item.getValue()), item.getDataType());
            Result itemResult = Result.builder().output(inputStreamTypedValue.getValue()).mediaType(inputStreamTypedValue.getDataType().getMediaType()).attributes((Object)attributes).build();
            pollItem.setResult(itemResult);
            if (RestSdkUtils.isNotBlank(this.watermarkExpression)) {
                pollItem.setWatermark(this.getItemWatermark(fullResponse, watermark, item));
            }
            if (RestSdkUtils.isNotBlank(this.identityExpression)) {
                pollItem.setId(this.getIdentity(fullResponse, watermark, item));
            }
        };
    }

    private String buildRequestPath(String pathTemplate, List<ParameterBinding> uriParams, Serializable watermark) {
        if (uriParams.isEmpty()) {
            return pathTemplate;
        }
        HashMap uriParamValues = new HashMap();
        uriParams.forEach(i -> uriParamValues.put(i.getKey(), this.getParameterValue(i.getValue(), watermark)));
        String path = pathTemplate;
        for (String key : uriParamValues.keySet()) {
            path = path.replace("{" + key + "}", (CharSequence)uriParamValues.get(key));
        }
        return path;
    }

    private String getParameterValue(String expression, Serializable watermark) {
        if (!DwUtils.isExpression(expression)) {
            return expression;
        }
        return (String)this.expressionLanguage.evaluate(expression, DataType.STRING, this.buildContext(null, watermark, null)).getValue();
    }

    protected DataType getWatermarkDataType() {
        return DataType.STRING;
    }

    private Serializable getItemWatermark(TypedValue<?> payload, Serializable currentWatermark, TypedValue<CursorStreamProvider> item) {
        return (Serializable)this.expressionLanguage.evaluate(this.watermarkExpression, this.getWatermarkDataType(), this.buildContext(payload, currentWatermark, item)).getValue();
    }

    private String getIdentity(TypedValue<?> payload, Serializable currentWatermark, TypedValue<CursorStreamProvider> item) {
        return (String)this.expressionLanguage.evaluate(this.identityExpression, DataType.STRING, this.buildContext(payload, currentWatermark, item)).getValue();
    }

    protected DataType getRequestBodyDataType() {
        return DataType.JSON_STRING;
    }

    private TypedValue<InputStream> getRequestBody(Serializable currentWatermark) {
        if (RestSdkUtils.isNotBlank(this.requestBodyExpression)) {
            TypedValue body = this.expressionLanguage.evaluate(this.requestBodyExpression, this.getRequestBodyDataType(), this.buildContext(null, currentWatermark, null));
            TypedValue<String> stringTypedValue = RestSdkUtils.consumeStringAndClose(body.getValue(), this.getDefaultResponseMediaType(), RestSdkUtils.resolveCharset(Optional.empty(), this.getDefaultResponseMediaType()));
            return new TypedValue((Object)new ByteArrayInputStream(((String)stringTypedValue.getValue()).getBytes()), body.getDataType());
        }
        return null;
    }

    private List<TypedValue<CursorStreamProvider>> getItems(TypedValue<String> fullResponse, Serializable currentWatermark) {
        TypedValue result = this.expressionLanguage.evaluate(this.itemsExpression, this.buildContext(fullResponse, currentWatermark, null));
        Iterator<TypedValue<?>> splitResult = SplitPayloadUtils.split(this.expressionLanguage, result, this.itemsExpression);
        Iterable iterable = () -> splitResult;
        return StreamSupport.stream(iterable.spliterator(), false).map(RequestStreamingUtils::getCursorStreamProviderValueFromSplitResult).collect(Collectors.toList());
    }

    private void validateExpression(String expression) throws SourceStartingException {
        if (RestSdkUtils.isBlank(expression)) {
            return;
        }
        ValidationResult validationResult = this.expressionLanguage.validate(expression);
        if (!validationResult.isSuccess()) {
            throw new SourceStartingException(String.format("Expression is not valid: %s", expression));
        }
    }

    private BindingContext buildContext(TypedValue<?> payload, Serializable currentWatermark, TypedValue<CursorStreamProvider> item) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", payload).addBinding("watermark", TypedValue.of((Object)currentWatermark)).addBinding("parameters", TypedValue.of(this.getParameterValues()));
        if (item != null) {
            builder.addBinding("item", item);
        }
        return builder.build();
    }

    public void onRejectedItem(Result<InputStream, HttpResponseAttributes> result, SourceCallbackContext callbackContext) {
        if (result.getOutput() != null) {
            RestSdkUtils.closeStream(result.getOutput());
        }
        LOGGER.debug("Item Rejected");
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

