/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.ArgumentBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.ExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.BindingArgumentBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingArgument;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.HttpRequestDataExpressionBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class HttpRequestDataExpressionBindingBuilder {
    private final List<BindingArgumentBuilder> headers = new ArrayList<BindingArgumentBuilder>();
    private final List<BindingArgumentBuilder> uriParameters = new ArrayList<BindingArgumentBuilder>();
    private final List<BindingArgumentBuilder> queryParameters = new ArrayList<BindingArgumentBuilder>();
    private ExpressionBuilder bodyExpression;

    private HttpRequestDataExpressionBindingBuilder addBindingArgument(String name, Consumer<BindingArgumentBuilder> consumer, List<BindingArgumentBuilder> argumentsList) {
        BindingArgumentBuilder bindingArgumentBuilder = new BindingArgumentBuilder(name);
        consumer.accept(bindingArgumentBuilder);
        argumentsList.add(bindingArgumentBuilder);
        return this;
    }

    public HttpRequestDataExpressionBindingBuilder header(String name, Consumer<BindingArgumentBuilder> consumer) {
        return this.addBindingArgument(name, consumer, this.headers);
    }

    public HttpRequestDataExpressionBindingBuilder uriParameter(String name, Consumer<BindingArgumentBuilder> consumer) {
        return this.addBindingArgument(name, consumer, this.uriParameters);
    }

    public HttpRequestDataExpressionBindingBuilder queryParameter(String name, Consumer<BindingArgumentBuilder> consumer) {
        return this.addBindingArgument(name, consumer, this.queryParameters);
    }

    public HttpRequestDataExpressionBindingBuilder body(Consumer<ExpressionBuilder> consumer) {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        consumer.accept(expressionBuilder);
        this.bodyExpression = expressionBuilder;
        return this;
    }

    private List<BindingArgument> buildArguments(List<BindingArgumentBuilder> arguments) {
        return arguments.stream().map(ArgumentBuilder::build).collect(Collectors.toList());
    }

    private List<BindingArgument> buildHeaders() {
        return this.buildArguments(this.headers);
    }

    private List<BindingArgument> buildUriParameters() {
        return this.buildArguments(this.uriParameters);
    }

    private List<BindingArgument> buildQueryParameters() {
        return this.buildArguments(this.queryParameters);
    }

    private Optional<Expression> buildBody() {
        return Optional.ofNullable(this.bodyExpression).map(ExpressionBuilder::build);
    }

    public HttpRequestDataExpressionBinding build() {
        return new HttpRequestDataExpressionBinding(this.buildHeaders(), this.buildUriParameters(), this.buildQueryParameters(), this.buildBody().orElse(null));
    }
}

