/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.sampledata;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.consumeStringAndClose;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.sdk.api.runtime.operation.Result;

import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * A base implementation of sample data for operations and triggers.
 *
 * @since 1.0
 */
public abstract class RestSampleDataProvider extends BaseRestSampleDataProvider<InputStream, HttpResponseAttributes> {

  @Override
  protected Result<InputStream, HttpResponseAttributes> transformOutputTypedValueResult(Result<TypedValue<InputStream>, HttpResponseAttributes> output) {
    TypedValue tOutput = output.getOutput();
    TypedValue<String> sOutput = consumeStringAndClose(tOutput.getValue(),
                                                       tOutput.getDataType().getMediaType(),
                                                       tOutput.getDataType().getMediaType().getCharset()
                                                           .orElse(config.getCharset()));

    return Result.<InputStream, HttpResponseAttributes>builder()
        .output(new ByteArrayInputStream(sOutput.getValue().getBytes()))
        .mediaType(output.getMediaType().orElse(null))
        .attributes(output.getAttributes().orElse(null))
        .attributesMediaType(output.getAttributesMediaType().orElse(null))
        .build();
  }

}
