/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import static com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext.PROPERTY_CONFIGURATION;
import static com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext.PROPERTY_CONNECTION;
import static com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext.PROPERTY_EXPRESSION_LANGUAGE;
import org.mule.runtime.api.el.ExpressionLanguage;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.SimpleEvaluationContext;

/**
 * Utils class for resolver framework specifics
 *
 * @since 1.0
 */
public class ResolverUtil {

  public static EvaluationContext createParentEvaluationContext(EvaluationContext globalEvaluationContext,
                                                                RestConfiguration config, RestConnection connection,
                                                                ExpressionLanguage expressionLanguage) {
    EvaluationContext parentEvaluationContext = new SimpleEvaluationContext(globalEvaluationContext);
    parentEvaluationContext.defineProperty(PROPERTY_CONFIGURATION, config);
    parentEvaluationContext.defineProperty(PROPERTY_CONNECTION, connection);
    parentEvaluationContext.defineProperty(PROPERTY_EXPRESSION_LANGUAGE, expressionLanguage);
    return parentEvaluationContext;
  }
}
