/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.binding;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.List;

/**
 * This class allows defining parameter bindings. A binding defines the value or expression that will be used to generate the
 * value of a parameter. Parameters and values defined here will be sent to the server in the http request.
 *
 * @since 1.0
 */
public class HttpRequestBinding {

  private final List<ParameterBinding> headers = new ArrayList<>();
  private final List<ParameterBinding> queryParams = new ArrayList<>();
  private final List<ParameterBinding> uriParams = new ArrayList<>();
  private ParameterBinding body = null;

  public List<ParameterBinding> getHeaders() {
    return headers;
  }

  public List<ParameterBinding> getQueryParams() {
    return queryParams;
  }

  public List<ParameterBinding> getUriParams() {
    return uriParams;
  }

  public ParameterBinding getBody() {
    return body;
  }

  public List<String> getAllBindingExpressions() {
    List<String> allBindings = headers.stream().map(ParameterBinding::getValue).collect(toList());
    allBindings.addAll(queryParams.stream().map(ParameterBinding::getValue).collect(toList()));
    allBindings.addAll(uriParams.stream().map(ParameterBinding::getValue).collect(toList()));

    if (getBody() != null) {
      allBindings.add(getBody().getValue());
    }

    return allBindings;
  }

  public void addHeaderBinding(String parameterName, String expression) {
    headers.add(new ParameterBinding(parameterName, expression));
  }

  public void addQueryParamBinding(String parameterName, String expression) {
    queryParams.add(new ParameterBinding(parameterName, expression));
  }

  public void addUriParamBinding(String parameterName, String expression) {
    uriParams.add(new ParameterBinding(parameterName, expression));
  }

  public void setBody(String expression) {
    this.body = new ParameterBinding.BodyBinding(expression);
  }
}
