/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.sdk.api.annotation.semantics.security.SecretToken;

/**
 * Base class for connection providers which use bearer authentication
 *
 * @since 1.0
 */
public abstract class BearerAuthenticationConnectionProvider extends BaseConnectionProvider {

  /**
   * The token to authenticate the requests
   */
  @Parameter
  @Summary("The token to authenticate the requests")
  @SecretToken
  protected String token;

  @Override
  protected RestConnection createConnection(HttpClient httpClient,
                                            HttpAuthentication authentication,
                                            MultiMap<String, String> defaultQueryParams,
                                            MultiMap<String, String> defaultHeaders) {
    return new BearerRestConnection(getBaseUri(),
                                    getConfigName(),
                                    httpClient,
                                    authentication,
                                    defaultQueryParams,
                                    defaultHeaders,
                                    getExpressionLanguage(),
                                    token);
  }

}
