/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.loadJsonSchema;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

/**
 * {@link SchemaOutputMetadataResolver} implementation for Json schemas. This class allows defining a custom metadata format for
 * the schema being loaded by overriding the getMetadataFormat() format.
 *
 * @since 1.0
 */
public abstract class FromJsonOutputMetadataResolver extends SchemaOutputMetadataResolver {

  protected abstract MetadataFormat getFormat();

  @Override
  protected MetadataType loadSchema(String schemaPath) {
    return loadJsonSchema(getClass().getClassLoader(), schemaPath, getFormat());
  }
}
