/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

/**
 * An interceptor to manipulate a server's HttpResponse before RSDK processes it and generates the Result. This would allow it to
 * handle responses from SaaS that don't signal errors with explicit response status or change the response content, reasonPhrase
 * and even a status code if needed.
 *
 * @since 1.0
 */
public interface HttpResponseInterceptor {

  /**
   * Defines if this interceptor should process the {@link HttpResponse}.
   *
   * @param httpRequest the HTTP request that was executed against the server.
   * @param httpResponse the server response to be intercepted. Entity's content could be read more than once as it is backed up *
   *        by repeatable streaming from Mule.
   * @param expressionLanguage Mule's {@link ExpressionLanguage} to allow using expressions for resolving the interception.
   * @return if {@code true} the {@link #intercept(InterceptionHttpRequest, HttpResponse, ExpressionLanguage)} method will be
   *         called, otherwise not.
   */
  default boolean match(InterceptionHttpRequest httpRequest, HttpResponse httpResponse, ExpressionLanguage expressionLanguage) {
    return false;
  }

  /**
   * Process an {@link HttpResponse} and generate a new one or return the one provided.
   *
   * @param httpRequest the HTTP request that was executed against the server.
   * @param httpResponse the server response to be intercepted. Entity's content could be read more than once as it is backed up
   *        by repeatable streaming from Mule.
   * @param expressionLanguage Mule's {@link ExpressionLanguage} to allow using expressions for resolving the interception.
   * @return the same or a new and modified {@link HttpResponse}.
   */
  default HttpResponse intercept(InterceptionHttpRequest httpRequest, HttpResponse httpResponse,
                                 ExpressionLanguage expressionLanguage) {
    return httpResponse;
  }

}
