/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.common;

import static com.mulesoft.connectivity.rest.commons.api.dw.DWBindings.WATERMARK;
import static com.mulesoft.connectivity.rest.commons.internal.util.ResolverUtil.addGlobalDefinitionsToEvaluationContext;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.SimpleEvaluationContext;

import java.util.HashMap;
import java.util.Map;

/**
 * Evaluation context builder for a trigger context.
 *
 * @since 1.0
 */
public class TriggerEvaluationContextBuilder extends EvaluationContextBuilder {

  private final static String KEY_PARAMETERS = DWBindings.PARAMETERS.getBinding();
  private final static String KEY_WATERMARK = WATERMARK.getBinding();

  private final Map<String, Object> parameters = new HashMap<>();

  public TriggerEvaluationContextBuilder(EvaluationContext globalEvaluationContext) {
    super(globalEvaluationContext);
  }

  /**
   * Adds a parameter to the evaluation context being built. These get later accessed via '{@link #KEY_PARAMETERS}.{name}'
   */
  public TriggerEvaluationContextBuilder parameter(String name, Object value) {
    setKeyValue(name, value, parameters);
    return this;
  }

  public EvaluationContext build() {
    final EvaluationContext evaluationContext = new SimpleEvaluationContext(buildGlobalEvaluationContext().orElse(null));
    evaluationContext.define(KEY_PARAMETERS, parameters);
    evaluationContext.define(KEY_WATERMARK, null);
    addGlobalDefinitionsToEvaluationContext(evaluationContext);
    return evaluationContext;
  }
}
