/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.sampledata;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.HttpRequestDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.ScriptDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.SequenceCompositeDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.sampledata.SampleDataResolverDefinition;

import java.util.function.Consumer;

/**
 * A fluent builder for a sample data resolver definition.
 *
 * @since 1.0
 */
public class SampleDataResolverDefinitionBuilder extends ResolverDefinitionBuilder<SampleDataResolverDefinition> {

  private HttpRequestDataExpressionBuilder resultDataExpressionBuilder;
  private ScriptDataExpressionBuilder transformDataExpressionBuilder;

  public SampleDataResolverDefinitionBuilder result(Consumer<HttpRequestDataExpressionBuilder> consumer) {
    HttpRequestDataExpressionBuilder builder = new HttpRequestDataExpressionBuilder();
    consumer.accept(builder);
    this.resultDataExpressionBuilder = builder;
    return this;
  }

  public SampleDataResolverDefinitionBuilder transform(Consumer<ScriptDataExpressionBuilder> consumer) {
    ScriptDataExpressionBuilder builder = new ScriptDataExpressionBuilder();
    consumer.accept(builder);
    this.transformDataExpressionBuilder = builder;
    return this;
  }

  private DataExpression buildResultExpression() {
    if (resultDataExpressionBuilder == null) {
      throw new IllegalStateException("No result expression set.");
    }

    SequenceCompositeDataExpressionBuilder sequenceBuilder = new SequenceCompositeDataExpressionBuilder();
    sequenceBuilder
        .step(stepBuilder -> stepBuilder.withDataExpression(resultDataExpressionBuilder.build()));

    if (transformDataExpressionBuilder != null) {
      sequenceBuilder.step(stepBuilder -> stepBuilder.withDataExpression(transformDataExpressionBuilder.build()));
    }

    return sequenceBuilder.build();
  }

  public SampleDataResolverDefinition build() {
    return new SampleDataResolverDefinition(buildResultExpression());
  }

}
