/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.interception;

import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.interception.InterceptionHttpRequest;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class CompositeHttpResponseInterceptor
implements HttpResponseInterceptor {
    private List<HttpResponseInterceptor> httpResponseInterceptors;
    private ExecutionStrategy executionStrategy;

    public CompositeHttpResponseInterceptor(List<HttpResponseInterceptor> httpResponseInterceptors, ExecutionStrategy executionStrategy) {
        Objects.requireNonNull(httpResponseInterceptors);
        Objects.requireNonNull(executionStrategy);
        this.httpResponseInterceptors = httpResponseInterceptors;
        this.executionStrategy = executionStrategy;
    }

    @Override
    public boolean match(InterceptionHttpRequest httpRequest, HttpResponse httpResponse, ExpressionLanguage expressionLanguage) {
        return this.httpResponseInterceptors.stream().filter(responseInterceptor -> responseInterceptor.match(httpRequest, httpResponse, expressionLanguage)).findAny().isPresent();
    }

    @Override
    public HttpResponse intercept(InterceptionHttpRequest httpRequest, HttpResponse httpResponse, ExpressionLanguage expressionLanguage) {
        for (HttpResponseInterceptor httpResponseInterceptor : this.httpResponseInterceptors) {
            if (!httpResponseInterceptor.match(httpRequest, httpResponse, expressionLanguage)) continue;
            httpResponse = httpResponseInterceptor.intercept(httpRequest, httpResponse, expressionLanguage);
            if (ExecutionStrategy.ONLY_FIRST != this.executionStrategy) continue;
            return httpResponse;
        }
        if (ExecutionStrategy.ONLY_FIRST == this.executionStrategy) {
            throw new IllegalStateException("At least one responseInterceptor from the composition should have matched the HttpResponse to be processed");
        }
        return httpResponse;
    }

    public static enum ExecutionStrategy {
        ALL,
        ONLY_FIRST;

    }
}

