/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation;

import com.mulesoft.connectivity.rest.commons.api.binding.HttpRequestBinding;
import com.mulesoft.connectivity.rest.commons.api.binding.HttpResponseBinding;
import com.mulesoft.connectivity.rest.commons.api.binding.ParameterBinding;
import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.multipart.MultipartPayloadBuilder;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.multipart.DWMultipartPayloadBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.CloserCompletionCallbackDecorator;
import com.mulesoft.connectivity.rest.commons.internal.util.DwUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public abstract class BaseRestOperation {
    @Inject
    private ExpressionLanguage expressionLanguage;

    public BaseRestOperation() {
    }

    public BaseRestOperation(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    protected void doRequest(RestConfiguration config, RestConnection connection, RestRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, Map<String, Object> parameterBindings, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        try {
            connection.request(builder, responseTimeoutMillis, this.resolveDefaultResponseMediaType(config), streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback, parameterBindings));
        }
        catch (Throwable t) {
            callback.error(t);
        }
    }

    protected MediaType resolveDefaultResponseMediaType(RestConfiguration config) {
        MediaType mediaType = this.getDefaultResponseMediaType();
        if (!mediaType.getCharset().isPresent()) {
            mediaType = mediaType.withCharset(config.getCharset());
        }
        return mediaType;
    }

    protected void doVoidRequest(RestConnection connection, RestRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, Map<String, Object> parameterBindings, CompletionCallback<String, HttpResponseAttributes> callback) {
        try {
            connection.bodylessRequest(builder, responseTimeoutMillis, MediaType.ANY, streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback, parameterBindings));
        }
        catch (Throwable t) {
            callback.error(t);
        }
    }

    protected <T> BiConsumer<Result<T, HttpResponseAttributes>, Throwable> handleResponse(CompletionCallback<T, HttpResponseAttributes> callback, Map<String, Object> parameterBindings) {
        return (result, error) -> {
            if (error != null) {
                callback.error(error);
            } else {
                try {
                    if (result.getOutput() instanceof InputStream) {
                        result = this.postProcessResult((Result<InputStream, HttpResponseAttributes>)result, parameterBindings);
                    }
                }
                catch (Throwable t) {
                    callback.error(t);
                }
                callback.success((Result)result);
            }
        };
    }

    protected <T, A> void withMultipart(Consumer<MultipartPayloadBuilder> builderConfigurer, CompletionCallback<T, A> callback, BiConsumer<TypedValue<InputStream>, CompletionCallback<T, A>> consumer) {
        DWMultipartPayloadBuilder builder = new DWMultipartPayloadBuilder(this.expressionLanguage);
        builderConfigurer.accept(builder);
        TypedValue<InputStream> multipart = builder.build();
        try {
            consumer.accept(multipart, new CloserCompletionCallbackDecorator<T, A>(callback, (Closeable)multipart.getValue()));
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)((Closeable)multipart.getValue()));
            callback.error((Throwable)e);
        }
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }

    protected ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    protected RestRequestBuilder getRequestBuilderWithBindings(String baseUri, String path, HttpConstants.Method method, RequestParameters requestParameters, ConfigurationOverrides overrides, RestConnection connection, RestConfiguration config, Map<String, Object> parameterBindings) {
        BindingContext bindingContext = this.getRequestBindingContext(connection, config, parameterBindings);
        HttpRequestBinding requestBindings = this.getRequestBindings();
        RestRequestBuilder restRequestBuilder = new RestRequestBuilder(baseUri, path, method, requestParameters);
        for (ParameterBinding binding : requestBindings.getUriParams()) {
            restRequestBuilder.addUriParam(binding.getKey(), this.resolveParameterExpression(binding.getValue(), bindingContext));
        }
        for (ParameterBinding binding : requestBindings.getQueryParams()) {
            restRequestBuilder.addQueryParam(binding.getKey(), this.resolveParameterExpression(binding.getValue(), bindingContext));
        }
        for (ParameterBinding binding : requestBindings.getHeaders()) {
            restRequestBuilder.addHeader(binding.getKey(), this.resolveParameterExpression(binding.getValue(), bindingContext));
        }
        if (requestBindings.getBody() != null) {
            TypedValue<?> payloadTypedValue = this.resolveRequestPayloadExpression(requestBindings.getBody().getValue(), bindingContext);
            restRequestBuilder.setBody(this.toInputStreamTypedValue(payloadTypedValue, RestSdkUtils.resolveCharset(Optional.empty(), this.getDefaultResponseMediaType())), overrides.getStreamingType());
        }
        return restRequestBuilder;
    }

    private DataType getRequestBodyDataType() {
        return this.toDataType(this.getRequestBodyMediaType());
    }

    private DataType getResponseBodyDataType() {
        return this.toDataType(this.getResponseBodyMediaType());
    }

    private DataType toDataType(String mediaType) {
        return DataType.builder().type(String.class).mediaType(mediaType).build();
    }

    protected String getRequestBodyMediaType() {
        return MediaType.APPLICATION_JSON.toString();
    }

    protected String getResponseBodyMediaType() {
        return MediaType.APPLICATION_JSON.toString();
    }

    protected HttpRequestBinding getRequestBindings() {
        return new HttpRequestBinding();
    }

    protected HttpResponseBinding getResponseBindings() {
        return new HttpResponseBinding();
    }

    private TypedValue<InputStream> toInputStreamTypedValue(TypedValue<?> typedValue, Charset charset) {
        if (typedValue == null) {
            return null;
        }
        return new TypedValue((Object)this.toInputStream(typedValue, charset), typedValue.getDataType());
    }

    private InputStream toInputStream(TypedValue<?> typedValue, Charset charset) {
        if (typedValue == null) {
            return null;
        }
        InputStream result = null;
        Object value = typedValue.getValue();
        if (value instanceof String) {
            String text = (String)value;
            result = new ByteArrayInputStream(text.getBytes(charset));
        } else if (value instanceof CursorStreamProvider) {
            CursorStreamProvider cursorStreamProvider = (CursorStreamProvider)value;
            result = (InputStream)cursorStreamProvider.openCursor();
        }
        return result;
    }

    private BindingContext getResponseBindingContext(Object payload, Map<String, Object> parameterBindings) {
        return BindingContext.builder().addBinding("parameters", RestSdkUtils.getTypedValueOrNull(parameterBindings)).addBinding("payload", RestSdkUtils.getTypedValueOrNull(payload)).build();
    }

    private BindingContext getRequestBindingContext(RestConnection connection, RestConfiguration config, Map<String, Object> parameterBindings) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("parameters", RestSdkUtils.getTypedValueOrNull(parameterBindings)).addBinding("configuration", RestSdkUtils.getTypedValueOrNull(config.getBindings())).addBinding("connection", RestSdkUtils.getTypedValueOrNull(connection.getBindings()));
        return builder.build();
    }

    private String resolveParameterExpression(String expression, BindingContext bindingContext) {
        if (!DwUtils.isExpression(expression)) {
            return expression;
        }
        return (String)this.getExpressionLanguage().evaluate(expression, DataType.STRING, bindingContext).getValue();
    }

    private TypedValue<?> resolveRequestPayloadExpression(String expression, BindingContext bindingContext) {
        return this.resolvePayloadExpression(expression, bindingContext, this.getRequestBodyDataType());
    }

    private TypedValue<?> resolveResponsePayloadExpression(String expression, BindingContext bindingContext) {
        return this.resolvePayloadExpression(expression, bindingContext, this.getResponseBodyDataType());
    }

    private TypedValue<?> resolvePayloadExpression(String expression, BindingContext bindingContext, DataType dataType) {
        if (!DwUtils.isExpression(expression)) {
            return TypedValue.of((Object)expression);
        }
        return this.getExpressionLanguage().evaluate(expression, dataType, bindingContext);
    }

    protected Result<InputStream, HttpResponseAttributes> postProcessResult(Result<InputStream, HttpResponseAttributes> result, Map<String, Object> parameterBindings) {
        if (this.getResponseBindings() == null || this.getResponseBindings().getBody() == null) {
            return result;
        }
        Result.Builder newResultBuilder = Result.builder();
        ParameterBinding bodyBinding = this.getResponseBindings().getBody();
        if (bodyBinding != null) {
            TypedValue<String> payload = RestSdkUtils.consumeStringAndClose(result.getOutput(), result.getMediaType().orElse(this.getDefaultResponseMediaType()), RestSdkUtils.resolveCharset(result.getMediaType(), this.getDefaultResponseMediaType()));
            BindingContext bindingContext = this.getResponseBindingContext(payload, parameterBindings);
            TypedValue<?> typedValue = this.resolveResponsePayloadExpression(bodyBinding.getValue(), bindingContext);
            InputStream inputStream = this.toInputStream(typedValue, RestSdkUtils.resolveCharset(result.getMediaType(), this.getDefaultResponseMediaType()));
            if (inputStream == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unexpected '%s' on result of evaluating response binding '%s'", (Object[])new Object[]{typedValue.getValue(), bodyBinding}));
            }
            newResultBuilder.output((Object)inputStream);
            newResultBuilder.output((Object)inputStream);
        }
        result.getMediaType().ifPresent(arg_0 -> ((Result.Builder)newResultBuilder).mediaType(arg_0));
        result.getAttributes().ifPresent(arg_0 -> ((Result.Builder)newResultBuilder).attributes(arg_0));
        result.getAttributesMediaType().ifPresent(arg_0 -> ((Result.Builder)newResultBuilder).attributesMediaType(arg_0));
        return newResultBuilder.build();
    }

    protected <T> CompletionCallback<T, HttpResponseAttributes> callbackObjectAttributesAdapter(final CompletionCallback<T, Object> callback) {
        return new CompletionCallback<T, HttpResponseAttributes>(){

            public void success(Result<T, HttpResponseAttributes> result) {
                callback.success(BaseRestOperation.this.toObjectResult(result));
            }

            public void error(Throwable throwable) {
                callback.error(throwable);
            }
        };
    }

    protected <T> Result<T, Object> toObjectResult(Result<? super T, HttpResponseAttributes> result) {
        Result.Builder builder = Result.builder();
        builder.output(result.getOutput());
        result.getMediaType().ifPresent(mediaType -> builder.mediaType(mediaType));
        result.getAttributes().ifPresent(attributes -> builder.attributes(attributes));
        result.getAttributesMediaType().ifPresent(attributesMediaType -> builder.attributesMediaType(attributesMediaType));
        result.getByteLength().ifPresent(byteLength -> builder.length(byteLength));
        return builder.build();
    }

    protected HttpResponseInterceptor getResponseInterceptors(RestConfiguration config) {
        return config.getResponseInterceptors();
    }
}

