/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.StringCaseUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

public class RestObjectHandler
implements SchemaHandler {
    public static final String PROPERTY_ORDER = "propertyOrder";
    public static final String CUSTOM_JSON_PROPERTY_PREFIX = "x-";

    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ObjectSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager, ParsingContext parsingContext) {
        ObjectSchema objectSchema = (ObjectSchema)schema;
        ObjectTypeBuilder objectMetadataBuilder = root.objectType().ordered(true);
        parsingContext.registerBuilder((Schema)objectSchema, (TypeBuilder<?>)objectMetadataBuilder);
        String id = objectSchema.getId();
        if (RestSdkUtils.isNotBlank(id)) {
            objectMetadataBuilder.id(id);
        }
        this.getObjectLabel(objectSchema).ifPresent(arg_0 -> ((ObjectTypeBuilder)objectMetadataBuilder).label(arg_0));
        List<Map.Entry<String, Schema>> orderedProperties = this.getOrderedProperties(objectSchema);
        List requiredProperties = objectSchema.getRequiredProperties();
        for (Map.Entry<String, Schema> property : orderedProperties) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField().key(property.getKey());
            this.processSchemaProperty(handlerManager, parsingContext, requiredProperties, property, field);
        }
        Map patternProperties = objectSchema.getPatternProperties();
        Collection entries = patternProperties.entrySet().stream().sorted(Comparator.comparing(o -> ((Pattern)o.getKey()).toString())).collect(Collectors.toList());
        for (Map.Entry patternSchemaEntry : entries) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField();
            field.key((Pattern)patternSchemaEntry.getKey());
            Schema value = (Schema)patternSchemaEntry.getValue();
            field.value(handlerManager.handle(value, parsingContext));
        }
        if (objectSchema.permitsAdditionalProperties()) {
            objectMetadataBuilder.openWith(handlerManager.handle(objectSchema.getSchemaOfAdditionalProperties(), parsingContext));
        }
        return objectMetadataBuilder;
    }

    protected void processSchemaProperty(RestHandlerManager handlerManager, ParsingContext parsingContext, List<String> requiredProperties, Map.Entry<String, Schema> property, ObjectFieldTypeBuilder field) {
        field.required(requiredProperties.contains(property.getKey()));
        Schema value = property.getValue();
        field.value(handlerManager.handle(value, parsingContext));
        RestObjectHandler.optional(() -> this.getFieldLabel((String)property.getKey(), (Schema)property.getValue()), () -> this.inferFieldLabel((String)property.getKey(), (Schema)property.getValue())).ifPresent(arg_0 -> ((ObjectFieldTypeBuilder)field).label(arg_0));
        RestObjectHandler.optional(() -> this.getFieldDescription((String)property.getKey(), (Schema)property.getValue()), () -> this.inferFieldDescription((String)property.getKey(), (Schema)property.getValue())).ifPresent(arg_0 -> ((ObjectFieldTypeBuilder)field).description(arg_0));
    }

    public static <T> Optional<T> optional(Supplier<Optional<T>> optional1Supplier, Supplier<Optional<T>> optional2Supplier) {
        Optional<T> optional = optional1Supplier.get();
        return optional.isPresent() ? optional : optional2Supplier.get();
    }

    public static Optional<String> nonBlank(String text) {
        return Optional.ofNullable(RestSdkUtils.isNotBlank(text) ? text : null);
    }

    protected Optional<String> getObjectLabel(ObjectSchema objectSchema) {
        return RestObjectHandler.nonBlank(objectSchema.getTitle());
    }

    protected Optional<String> getFieldLabel(String id, Schema property) {
        return RestObjectHandler.nonBlank(property.getTitle());
    }

    protected Optional<String> inferFieldLabel(String id, Schema property) {
        return RestObjectHandler.nonBlank(StringCaseUtils.titleCase(id));
    }

    protected Optional<String> getFieldDescription(String id, Schema property) {
        return RestObjectHandler.nonBlank(property.getDescription());
    }

    protected Optional<String> inferFieldDescription(String id, Schema property) {
        return RestObjectHandler.optional(() -> RestObjectHandler.nonBlank(property.getTitle()), () -> RestObjectHandler.nonBlank(id)).map(StringCaseUtils::sentenceCase);
    }

    private List<Map.Entry<String, Schema>> getOrderedProperties(ObjectSchema objectSchema) {
        ArrayList<?> propertyOrderArray = this.getPropertyOrder(objectSchema);
        HashMap propertySchemas = new HashMap(objectSchema.getPropertySchemas());
        if (propertyOrderArray == null) {
            return new ArrayList<Map.Entry<String, Schema>>(propertySchemas.entrySet());
        }
        ArrayList<Map.Entry<String, Schema>> result = new ArrayList<Map.Entry<String, Schema>>();
        for (Object propertyOrderItem : propertyOrderArray) {
            String key;
            Schema schema;
            if (!(propertyOrderItem instanceof String) || (schema = (Schema)propertySchemas.get(key = (String)propertyOrderItem)) == null) continue;
            propertySchemas.remove(key);
            result.add(new AbstractMap.SimpleEntry<String, Schema>(key, schema));
        }
        result.addAll(propertySchemas.entrySet());
        return result;
    }

    private ArrayList<?> getPropertyOrder(ObjectSchema objectSchema) {
        ArrayList<?> propertyOrder = this.getPropertyOrder(objectSchema, PROPERTY_ORDER);
        if (propertyOrder == null) {
            propertyOrder = this.getPropertyOrder(objectSchema, "x-propertyOrder");
        }
        return propertyOrder;
    }

    private ArrayList<?> getPropertyOrder(ObjectSchema objectSchema, String propertyName) {
        Object propertyOrderObject;
        if (objectSchema.getUnprocessedProperties().containsKey(propertyName) && (propertyOrderObject = objectSchema.getUnprocessedProperties().get(propertyName)) instanceof ArrayList) {
            return (ArrayList)propertyOrderObject;
        }
        return null;
    }
}

