/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;

public class HttpEntityCursorStreamProviderBased
implements HttpEntity {
    private CursorStreamProvider cursorStreamProvider;
    private OptionalLong contentLength;

    public HttpEntityCursorStreamProviderBased(CursorStreamProvider cursorStreamProvider, OptionalLong contentLength) {
        Objects.requireNonNull(cursorStreamProvider, "cursorStreamProvider cannot be null.");
        Objects.requireNonNull(contentLength, "contentLength cannot be null.");
        this.cursorStreamProvider = cursorStreamProvider;
        this.contentLength = contentLength;
    }

    public boolean isStreaming() {
        return true;
    }

    public boolean isComposed() {
        return false;
    }

    public InputStream getContent() {
        return (InputStream)this.cursorStreamProvider.openCursor();
    }

    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)((InputStream)this.cursorStreamProvider.openCursor()));
    }

    public Collection<HttpPart> getParts() {
        return Collections.emptyList();
    }

    public Optional<Long> getLength() {
        return this.contentLength.isPresent() ? Optional.of(this.contentLength.getAsLong()) : Optional.empty();
    }

    public OptionalLong getBytesLength() {
        return this.contentLength;
    }
}

