/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import org.mule.runtime.core.api.util.StringUtils;

public class StringCaseUtils {
    private static final String SEPARATOR_CHARS = " -_.?!$%";

    public static String titleCase(String text) {
        return StringCaseUtils.textCase(text, true);
    }

    public static String sentenceCase(String text) {
        return StringCaseUtils.textCase(text, false);
    }

    public static String textCase(String text, boolean capitalizeAllWords) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String result = StringCaseUtils.camelCaseSeparate(text);
        CharSequence[] words = StringUtils.splitAndTrim((String)result, (String)SEPARATOR_CHARS);
        if (words.length > 0) {
            if (capitalizeAllWords) {
                for (int i = 0; i < words.length; ++i) {
                    words[i] = StringCaseUtils.capitalize((String)words[i]);
                }
            } else {
                words[0] = StringCaseUtils.capitalize((String)words[0]);
            }
        }
        return String.join((CharSequence)" ", words);
    }

    private static String capitalize(String word) {
        if (word == null || word.length() == 0) {
            return word;
        }
        return Character.toUpperCase(word.charAt(0)) + word.substring(1, word.length());
    }

    private static String camelCaseSeparate(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String result = text.replaceAll("(\\D)(\\d)", "$1 $2").replaceAll("(\\d)(\\D)", "$1 $2").replaceAll("([A-Z])([A-Z])([a-z])", "$1 $2$3").replaceAll("([a-z])([A-Z]+)", "$1 $2").toLowerCase();
        return result;
    }
}

