/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.expression;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.interception.InterceptionHttpRequest;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public abstract class BaseExpressionHttpResponseInterceptor
implements HttpResponseInterceptor {
    protected MediaType defaultResponseMediaType;

    protected BaseExpressionHttpResponseInterceptor(MediaType defaultResponseMediaType) {
        Objects.requireNonNull(defaultResponseMediaType);
        this.defaultResponseMediaType = defaultResponseMediaType;
    }

    protected BindingContext createBindingContext(InterceptionHttpRequest httpRequest, HttpResponse httpResponse) {
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        bindingContextBuilder.addBinding(DWBindings.REQUEST.getBinding(), TypedValue.of((Object)httpRequest));
        MediaType mediaType = this.getMediaType(httpResponse);
        bindingContextBuilder.addBinding(DWBindings.STATUS_CODE.getBinding(), TypedValue.of((Object)httpResponse.getStatusCode()));
        bindingContextBuilder.addBinding(DWBindings.REASON_PHRASE.getBinding(), TypedValue.of((Object)httpResponse.getReasonPhrase()));
        bindingContextBuilder.addBinding(DWBindings.HEADERS.getBinding(), TypedValue.of((Object)httpResponse.getHeaders()));
        bindingContextBuilder.addBinding(DWBindings.BODY.getBinding(), new TypedValue((Object)httpResponse.getEntity().getContent(), DataType.builder().mediaType(mediaType).charset(RestSdkUtils.resolveCharset(Optional.empty(), mediaType)).build()));
        return bindingContextBuilder.build();
    }

    protected MediaType getMediaType(HttpResponse httpResponse) {
        return RestSdkUtils.getMediaType(httpResponse, this.defaultResponseMediaType);
    }

    protected <T> TypedValue<T> evaluate(String expression, BindingContext bindingContext, DataType dataType, ExpressionLanguage expressionLanguage) {
        return this.doEvaluate(expression, bindingContext, dataType, expressionLanguage);
    }

    private <T> TypedValue<T> doEvaluate(String expression, BindingContext bindingContext, DataType dataType, ExpressionLanguage expressionLanguage) {
        return expressionLanguage.evaluate(expression, dataType, bindingContext);
    }
}

