/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.expression;

import com.mulesoft.connectivity.rest.commons.api.interception.InterceptionHttpRequest;
import com.mulesoft.connectivity.rest.commons.api.interception.expression.BaseExpressionHttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.internal.model.http.HttpEntityCursorStreamProviderBased;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerProperties;

public class ExpressionHttpResponseInterceptor
extends BaseExpressionHttpResponseInterceptor {
    private String matchExpression;
    private String statusCodeExpression;
    private String reasonPhraseExpression;
    private String headersExpression;
    private String bodyExpression;

    private ExpressionHttpResponseInterceptor(String matchExpression, String statusCodeExpression, String reasonPhraseExpression, String headersExpression, String bodyExpression, MediaType defaultResponseMediaType) {
        super(defaultResponseMediaType);
        Objects.requireNonNull(matchExpression);
        this.matchExpression = matchExpression;
        this.statusCodeExpression = statusCodeExpression;
        this.reasonPhraseExpression = reasonPhraseExpression;
        this.headersExpression = headersExpression;
        this.bodyExpression = bodyExpression;
    }

    @Override
    public boolean match(InterceptionHttpRequest httpRequest, HttpResponse httpResponse, ExpressionLanguage expressionLanguage) {
        return (Boolean)this.evaluate(this.matchExpression, this.createBindingContext(httpRequest, httpResponse), DataType.BOOLEAN, expressionLanguage).getValue();
    }

    @Override
    public HttpResponse intercept(InterceptionHttpRequest httpRequest, HttpResponse httpResponse, ExpressionLanguage expressionLanguage) {
        int statusCode = (Integer)this.getStatusCodeExpression().map(expression -> this.evaluate((String)expression, this.createBindingContext(httpRequest, httpResponse), DataType.fromType(Integer.class), expressionLanguage).getValue()).orElseGet(() -> httpResponse.getStatusCode());
        String reasonPhrase = (String)this.getReasonPhraseExpression().map(expression -> this.evaluate((String)expression, this.createBindingContext(httpRequest, httpResponse), DataType.fromType(String.class), expressionLanguage).getValue()).orElseGet(() -> httpResponse.getReasonPhrase());
        MultiMap<String, String> headers = (MultiMap<String, String>)this.getHeadersExpression().map(expression -> this.evaluate(this.headersExpression, this.createBindingContext(httpRequest, httpResponse), DataType.fromType(MultiMap.class), expressionLanguage).getValue()).orElseGet(() -> httpResponse.getHeaders());
        HttpEntity entity = httpResponse.getEntity();
        boolean closeCursorStreamProviderOnHttpResponse = false;
        if (this.getBodyExpression().isPresent()) {
            String bodyExpression = this.getBodyExpression().get();
            TypedValue<Object> transformedBody = this.evaluateBodyExpression(bodyExpression, httpResponse, this.createBindingContext(httpRequest, httpResponse), expressionLanguage);
            if (transformedBody.getValue() instanceof CursorStreamProvider) {
                CursorStreamProvider cursorStreamProvider = (CursorStreamProvider)transformedBody.getValue();
                entity = new HttpEntityCursorStreamProviderBased(cursorStreamProvider, transformedBody.getByteLength());
                if (httpResponse.getEntity() instanceof HttpEntityCursorStreamProviderBased && ((HttpEntityCursorStreamProviderBased)httpResponse.getEntity()).getCursorStreamProvider() != cursorStreamProvider) {
                    closeCursorStreamProviderOnHttpResponse = true;
                }
            } else if (transformedBody.getValue() instanceof CursorStream) {
                entity = new HttpEntityCursorStreamProviderBased((CursorStreamProvider)((CursorStream)transformedBody.getValue()).getProvider(), transformedBody.getByteLength());
            } else {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"HTTP response interceptor expression for body has generated a non recognizable output: '%s'. This is probably a bug.", (Object[])new Object[]{transformedBody.getValue().getClass().getName()}));
            }
            headers = this.updateContentTypeHeader(headers, entity);
        }
        if (closeCursorStreamProviderOnHttpResponse) {
            ((HttpEntityCursorStreamProviderBased)httpResponse.getEntity()).getCursorStreamProvider().close();
        }
        return ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).reasonPhrase(reasonPhrase).entity(entity)).headers((MultiMap)headers)).build();
    }

    private TypedValue<Object> evaluateBodyExpression(String bodyExpression, HttpResponse httpResponse, BindingContext bindingContext, ExpressionLanguage expressionLanguage) {
        CompiledExpression compile = expressionLanguage.compile(bodyExpression, bindingContext);
        MediaType mediaType = compile.outputType().orElse(this.getMediaType(httpResponse));
        return expressionLanguage.evaluate(bodyExpression, DataType.builder().mediaType(mediaType).charset(RestSdkUtils.resolveCharset(Optional.empty(), mediaType)).build(), bindingContext);
    }

    private MultiMap<String, String> updateContentTypeHeader(MultiMap<String, String> headers, HttpEntity entity) {
        if (!headers.containsKey((Object)"Content-Length") && !headers.containsKey((Object)"Content-Length".toLowerCase())) {
            return headers;
        }
        MultiMap.StringMultiMap modifiedHeaders = new MultiMap.StringMultiMap();
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase("Content-Length")) continue;
            modifiedHeaders.put((Object)key, (Collection)headers.getAll((Object)key));
        }
        try {
            modifiedHeaders.put((Object)(HttpServerProperties.PRESERVE_HEADER_CASE ? "Content-Length" : "Content-Length".toLowerCase()), (Object)String.valueOf(entity.getBytes().length));
            return modifiedHeaders;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"There was an error while trying to resolve the content length for the transformed body response"), (Throwable)e);
        }
    }

    private Optional<String> getBodyExpression() {
        return Optional.ofNullable(this.bodyExpression);
    }

    private Optional<String> getHeadersExpression() {
        return Optional.ofNullable(this.headersExpression);
    }

    private Optional<String> getStatusCodeExpression() {
        return Optional.ofNullable(this.statusCodeExpression);
    }

    private Optional<String> getReasonPhraseExpression() {
        return Optional.ofNullable(this.reasonPhraseExpression);
    }

    public static ExpressionHttpResponseInterceptorBuilder builder() {
        return new ExpressionHttpResponseInterceptorBuilder();
    }

    public static class ExpressionHttpResponseInterceptorBuilder {
        private String matchExpression;
        protected String statusCodeExpression;
        protected String reasonPhraseExpression;
        protected String headersExpression;
        protected String bodyExpression;
        protected MediaType defaultResponseMediaType;

        public ExpressionHttpResponseInterceptorBuilder matchExpression(String matchExpression) {
            Objects.requireNonNull(matchExpression);
            this.matchExpression = matchExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder statusCodeExpression(String statusCodeExpression) {
            Objects.requireNonNull(statusCodeExpression);
            this.statusCodeExpression = statusCodeExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder reasonPhraseExpression(String reasonPhraseExpression) {
            Objects.requireNonNull(reasonPhraseExpression);
            this.reasonPhraseExpression = reasonPhraseExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder headersExpression(String headersExpression) {
            Objects.requireNonNull(headersExpression);
            this.headersExpression = headersExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder bodyExpression(String bodyExpression) {
            Objects.requireNonNull(bodyExpression);
            this.bodyExpression = bodyExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder defaultResponseMediaType(MediaType defaultResponseMediaType) {
            Objects.requireNonNull(defaultResponseMediaType);
            this.defaultResponseMediaType = defaultResponseMediaType;
            return this;
        }

        public ExpressionHttpResponseInterceptor build() {
            return new ExpressionHttpResponseInterceptor(this.matchExpression, this.statusCodeExpression, this.reasonPhraseExpression, this.headersExpression, this.bodyExpression, this.defaultResponseMediaType);
        }
    }
}

