/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.common;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.EvaluationContextBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.SimpleEvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.util.ResolverUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.metadata.TypedValue;

public class OperationEvaluationContextBuilder
extends EvaluationContextBuilder {
    private static final String KEY_HEADERS = DWBindings.HEADERS.getBinding();
    private static final String KEY_URI_PARAMETERS = DWBindings.URIS.getBinding();
    private static final String KEY_QUERY_PARAMETERS = DWBindings.QUERIES.getBinding();
    private static final String KEY_AUXILIAR_PARAMETERS = DWBindings.PARAMETERS.getBinding();
    private static final String BODY_PARAMETERS = DWBindings.BODY.getBinding();
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private final Map<String, Object> uriParameters = new HashMap<String, Object>();
    private final Map<String, Object> queryParameters = new HashMap<String, Object>();
    private final Map<String, Object> auxiliarParameters = new HashMap<String, Object>();
    private final Map<String, Object> body = new HashMap<String, Object>();

    public OperationEvaluationContextBuilder(EvaluationContext globalEvaluationContext) {
        super(globalEvaluationContext);
    }

    public OperationEvaluationContextBuilder uriParameter(String name, Object value) {
        this.setKeyValue(name, value, this.uriParameters);
        return this;
    }

    public OperationEvaluationContextBuilder queryParameter(String name, Object value) {
        this.setKeyValue(name, value, this.queryParameters);
        return this;
    }

    public OperationEvaluationContextBuilder parameters(String name, Object value) {
        this.setKeyValue(name, value, this.auxiliarParameters);
        return this;
    }

    public OperationEvaluationContextBuilder header(String name, Object value) {
        this.setKeyValue(name, value, this.headers);
        return this;
    }

    public OperationEvaluationContextBuilder body(String name, Object value) {
        List<String> path = Arrays.asList(name.split("\\."));
        Map map = this.body;
        for (int i = 0; i < path.size() - 1; ++i) {
            String key = path.get(i);
            if (!map.containsKey(key)) {
                this.setKeyValue(key, new HashMap(), map);
            }
            map = (Map)((TypedValue)map.get(key)).getValue();
        }
        this.setKeyValue(path.get(path.size() - 1), value, map);
        return this;
    }

    @Override
    public EvaluationContext build() {
        SimpleEvaluationContext evaluationContext = new SimpleEvaluationContext(this.buildGlobalEvaluationContext().orElse(null));
        evaluationContext.define(KEY_HEADERS, this.headers);
        evaluationContext.define(KEY_URI_PARAMETERS, this.uriParameters);
        evaluationContext.define(KEY_QUERY_PARAMETERS, this.queryParameters);
        evaluationContext.define(BODY_PARAMETERS, this.body);
        evaluationContext.define(KEY_AUXILIAR_PARAMETERS, this.auxiliarParameters);
        ResolverUtil.addGlobalDefinitionsToEvaluationContext(evaluationContext);
        return evaluationContext;
    }
}

