/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.descriptor;

import static java.util.Objects.requireNonNull;

import java.util.List;

public class CompositeHttpResponseInterceptorDescriptor extends HttpResponseInterceptorDescriptor {

  private List<HttpResponseInterceptorDescriptor> httpResponseInterceptorDescriptors;

  public CompositeHttpResponseInterceptorDescriptor(List<HttpResponseInterceptorDescriptor> httpResponseInterceptorDescriptors) {
    this.httpResponseInterceptorDescriptors =
        requireNonNull(httpResponseInterceptorDescriptors, "httpResponseInterceptorDescriptors cannot be null");
  }

  public List<HttpResponseInterceptorDescriptor> getHttpResponseInterceptorDescriptors() {
    return httpResponseInterceptorDescriptors;
  }

  @Override
  public void accept(HttpResponseInterceptorDescriptorVisitor visitor) {
    visitor.visit(this);
  }

}
