/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.descriptor.builder;

import static java.util.stream.Collectors.toList;

import org.mule.api.annotation.NoImplement;

import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.CompositeHttpResponseInterceptorDescriptor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.HttpResponseInterceptorDescriptor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * A descriptor builder to create a descriptor for a
 * {@link com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor}.
 *
 * @since 1.0
 */
@NoImplement
public class HttpResponseInterceptorDescriptorBuilder {

  private List<ExpressionHttpResponseInterceptorDescriptionBuilder> expressionHttpResponseInterceptorDescriptionBuilders =
      new ArrayList<>();
  private List<PreconditionHttpResponseInterceptorDelegateDescriptorBuilder> preconditionHttpResponseInterceptorDelegateDescriptorBuilders =
      new ArrayList<>();

  /**
   * Defines a conditional descriptor, it gets added to the chain of interceptors.
   *
   * @param builderConfigurator the consumer to configure the conditional based interceptor.
   * @return this
   */
  public HttpResponseInterceptorDescriptorBuilder when(PreconditionHttpResponseInterceptorDelegateDescriptorBuilder.Matcher preconditionMatcher,
                                                       Consumer<PreconditionHttpResponseInterceptorDelegateDescriptorBuilder> builderConfigurator) {
    PreconditionHttpResponseInterceptorDelegateDescriptorBuilder preconditionHttpResponseInterceptorDelegateDescriptorBuilder =
        new PreconditionHttpResponseInterceptorDelegateDescriptorBuilder(preconditionMatcher);
    builderConfigurator.accept(preconditionHttpResponseInterceptorDelegateDescriptorBuilder);
    preconditionHttpResponseInterceptorDelegateDescriptorBuilders
        .add(preconditionHttpResponseInterceptorDelegateDescriptorBuilder);
    return this;
  }

  /**
   * Defines an expression based descriptor, it gets added to the chain of interceptors.
   *
   * @param builderConfigurator the consumer to configure the expression based interceptor.
   * @return this
   */
  public HttpResponseInterceptorDescriptorBuilder expression(Consumer<ExpressionHttpResponseInterceptorDescriptionBuilder> builderConfigurator) {
    ExpressionHttpResponseInterceptorDescriptionBuilder expressionHttpResponseInterceptorDescriptionBuilder =
        new ExpressionHttpResponseInterceptorDescriptionBuilder();
    builderConfigurator.accept(expressionHttpResponseInterceptorDescriptionBuilder);
    expressionHttpResponseInterceptorDescriptionBuilders.add(expressionHttpResponseInterceptorDescriptionBuilder);
    return this;
  }

  /**
   * @return builds the instance of the descriptor.
   * @throws {@link IllegalStateException} if neither an expression nor conditional descriptor interceptor has been defined.
   */
  public HttpResponseInterceptorDescriptor build() {
    List<HttpResponseInterceptorDescriptor> descriptors = new ArrayList<>();
    if (!this.expressionHttpResponseInterceptorDescriptionBuilders.isEmpty()) {
      descriptors.addAll(this.expressionHttpResponseInterceptorDescriptionBuilders.stream()
          .map(e -> e.build())
          .collect(toList()));
    } else if (!this.preconditionHttpResponseInterceptorDelegateDescriptorBuilders.isEmpty()) {
      descriptors.addAll(this.preconditionHttpResponseInterceptorDelegateDescriptorBuilders.stream()
          .map(e -> e.build())
          .collect(toList()));
    }

    if (descriptors.isEmpty()) {
      throw new IllegalStateException(
                                      "The builder has not been configured with a descriptor definition to intercept Http responses. This is probably a bug.");
    }

    if (descriptors.size() == 1) {
      return descriptors.get(0);
    }
    return new CompositeHttpResponseInterceptorDescriptor(descriptors);
  }

}
