/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.queryparam;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.stringValue;
import static java.lang.String.join;
import static java.util.stream.Collectors.toList;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;

import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/***
 * A {@link RequestParameterFormatter} that formats the query parameters multimap so arrays are split with commas i.e
 * queryParam1=value1,value2&queryParam2=value3
 *
 * @since 1.0
 */
public class CommaRequestParameterFormatter extends RequestParameterFormatter {

  @Override
  public MultiMap<String, String> format(Map<String, Object> parameters, boolean caseSensitive) {

    MultiMap<String, String> formatted = (caseSensitive ? new MultiMap<>() : new CaseInsensitiveMultiMap(false));

    for (String parameterKey : parameters.keySet()) {
      Object value = parameters.get(parameterKey);

      if (value instanceof Collection) {
        Collection<?> collectionValue = (Collection<?>) value;
        List<String> stringValues = collectionValue.stream().map(RestSdkUtils::stringValue).collect(toList());
        formatted.put(parameterKey, join(",", stringValues));
      } else {
        formatted.put(parameterKey, stringValue(value));
      }
    }

    return formatted;
  }
}
