/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.common;

import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;

/**
 * A fluent builder for expressions.
 *
 * @since 1.0
 */
public class ExpressionBuilder {

  private String language;
  private String expression;

  public ExpressionBuilder language(String language) {
    this.language = language;
    return this;
  }

  public ExpressionBuilder expression(String expression) {
    this.expression = expression;
    return this;
  }

  public Expression build() {
    return new Expression(language, expression);
  }
}
