/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.streaming;

import static com.mulesoft.connectivity.rest.commons.internal.RestConstants.PAYLOAD_VAR;
import static java.util.Objects.requireNonNull;
import static org.mule.runtime.api.metadata.TypedValue.of;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;

import com.mulesoft.connectivity.rest.commons.api.streaming.StreamingHelper;

import java.io.InputStream;

/**
 * An implementation that relies on Mule's {@link org.mule.runtime.extension.api.runtime.streaming.StreamingHelper} which should
 * be used in the context of enrichers, polling sources where
 * {@link org.mule.runtime.extension.api.runtime.streaming.StreamingHelper} is not accessible.
 */
public class DataWeaveBasedStreamingHelper implements StreamingHelper {

  private ExpressionLanguage expressionLanguage;

  public DataWeaveBasedStreamingHelper(ExpressionLanguage expressionLanguage) {
    this.expressionLanguage = requireNonNull(expressionLanguage, "expressionLanguage cannot be null");
  }

  @Override
  public CursorStreamProvider resolveCursorStreamProvider(InputStream value) {
    TypedValue<CursorStreamProvider> cursorStreamProviderTypedValue = (TypedValue<CursorStreamProvider>) expressionLanguage
        .evaluate(PAYLOAD_VAR,
                  DataType.CURSOR_STREAM_PROVIDER,
                  BindingContext.builder()
                      .addBinding(PAYLOAD_VAR, of(value))
                      .build());
    return cursorStreamProviderTypedValue.getValue();
  }
}
